/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.tag.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class TagsEndpointPromise implements net.bluemind.tag.api.ITagsPromise {

	private net.bluemind.tag.api.ITagsAsync impl;

	public TagsEndpointPromise(net.bluemind.tag.api.ITagsAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.tag.api.Tag>>> all() {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.tag.api.Tag>>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.tag.api.Tag>>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.tag.api.Tag>>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.tag.api.Tag>>>() {
			public void success(List<net.bluemind.core.container.model.ItemValue<net.bluemind.tag.api.Tag>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.all( handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.tag.api.Tag>>> multipleGet(List<String> uids  ) {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.tag.api.Tag>>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.tag.api.Tag>>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.tag.api.Tag>>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.tag.api.Tag>>>() {
			public void success(List<net.bluemind.core.container.model.ItemValue<net.bluemind.tag.api.Tag>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.multipleGet(uids,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<String>> allUids() {
		
		CompletableFuture<List<String>> ret = new CompletableFuture<List<String>>();
		AsyncHandler<List<String>> handler = new AsyncHandler<List<String>>() {
			public void success(List<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.allUids( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ContainerChangelog> changelog(Long since  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ContainerChangelog> ret = new CompletableFuture<net.bluemind.core.container.model.ContainerChangelog>();
		AsyncHandler<net.bluemind.core.container.model.ContainerChangelog> handler = new AsyncHandler<net.bluemind.core.container.model.ContainerChangelog>() {
			public void success(net.bluemind.core.container.model.ContainerChangelog value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.changelog(since,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> update(String uid ,  net.bluemind.tag.api.Tag tag  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.update(uid, tag,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ContainerUpdatesResult> updates(net.bluemind.tag.api.TagChanges changes  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ContainerUpdatesResult> ret = new CompletableFuture<net.bluemind.core.container.model.ContainerUpdatesResult>();
		AsyncHandler<net.bluemind.core.container.model.ContainerUpdatesResult> handler = new AsyncHandler<net.bluemind.core.container.model.ContainerUpdatesResult>() {
			public void success(net.bluemind.core.container.model.ContainerUpdatesResult value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.updates(changes,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> delete(String uid  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.delete(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<String>> changeset(Long since  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<String>> ret = new CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<String>>();
		AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<String>> handler = new AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<String>>() {
			public void success(net.bluemind.core.container.model.ContainerChangeset<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.changeset(since,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.tag.api.Tag>> getComplete(String uid  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.tag.api.Tag>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.tag.api.Tag>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.tag.api.Tag>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.tag.api.Tag>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.tag.api.Tag> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getComplete(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> create(String uid ,  net.bluemind.tag.api.Tag tag  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.create(uid, tag,  handler);
		return ret;
	}

}
