/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.externaluser.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.json.client.JSONValue;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;

public class ExternalUserGwtEndpoint implements net.bluemind.externaluser.api.IExternalUserAsync {

	private String baseUri;

	private String sessionId;

	private String root = "/api";

	public ExternalUserGwtEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/externaluser/{domainUid}";
		this.sessionId = sessionId;
	
		uri_ = uri_.replace("{domainUid}",pathVars[0]);
		
		baseUri = uri_;
	}

	public ExternalUserGwtEndpoint withRoot(String root) {
		this.root = root;
		return this;
	}

	@Override
	public void memberOf(String uid, final AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>> handler) {
		String postUri = "/{uid}/groups";

		postUri = postUri.replace("{uid}", ""+uid);
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>>(handler) {
			@Override
			protected List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.group.api.gwt.serder.GroupGwtSerDer())).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void memberOfGroups(String uid, final AsyncHandler<List<String>> handler) {
		String postUri = "/{uid}/groupUids";

		postUri = postUri.replace("{uid}", ""+uid);
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<String>>(handler) {
			@Override
			protected List<String> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void byExtId(String extid, final AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.externaluser.api.ExternalUser>> handler) {
		String postUri = "/byExtId/{extid}";

		postUri = postUri.replace("{extid}", ""+extid);
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.model.ItemValue<net.bluemind.externaluser.api.ExternalUser>>(handler) {
			@Override
			protected net.bluemind.core.container.model.ItemValue<net.bluemind.externaluser.api.ExternalUser> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.externaluser.api.gwt.serder.ExternalUserGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void update(String uid, net.bluemind.externaluser.api.ExternalUser externalUser, final AsyncHandler<Void> handler) {
		String postUri = "/{uid}";

		postUri = postUri.replace("{uid}", ""+uid);
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.externaluser.api.gwt.serder.ExternalUserGwtSerDer().serialize( externalUser);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void delete(String uid, final AsyncHandler<Void> handler) {
		String postUri = "/{uid}";

		postUri = postUri.replace("{uid}", ""+uid);
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.DELETE, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getComplete(String uid, final AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.externaluser.api.ExternalUser>> handler) {
		String postUri = "/{uid}/complete";

		postUri = postUri.replace("{uid}", ""+uid);
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.model.ItemValue<net.bluemind.externaluser.api.ExternalUser>>(handler) {
			@Override
			protected net.bluemind.core.container.model.ItemValue<net.bluemind.externaluser.api.ExternalUser> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.externaluser.api.gwt.serder.ExternalUserGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void create(String uid, net.bluemind.externaluser.api.ExternalUser externalUser, final AsyncHandler<Void> handler) {
		String postUri = "/{uid}";

		postUri = postUri.replace("{uid}", ""+uid);
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.PUT, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.externaluser.api.gwt.serder.ExternalUserGwtSerDer().serialize( externalUser);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void createWithExtId(String uid, String extid, net.bluemind.externaluser.api.ExternalUser externalUser, final AsyncHandler<Void> handler) {
		String postUri = "/{uid}/{extid}/createwithextid";

		postUri = postUri.replace("{uid}", ""+uid);
		postUri = postUri.replace("{extid}", ""+extid);
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.PUT, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.externaluser.api.gwt.serder.ExternalUserGwtSerDer().serialize( externalUser);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}

	public net.bluemind.externaluser.api.IExternalUserPromise promiseApi() {
		return new ExternalUserEndpointPromise(this);
	}
}
