/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailmessage.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MailTipFilterGwtSerDer implements GwtSerDer<net.bluemind.mailmessage.api.MailTipFilter> {

	public MailTipFilterGwtSerDer( ) {
	}

	@Override
	public net.bluemind.mailmessage.api.MailTipFilter deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.mailmessage.api.MailTipFilter ret = new net.bluemind.mailmessage.api.MailTipFilter();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.mailmessage.api.MailTipFilter ret, JSONObject json) {

		JSONValue mailTipsJSON = json.get("mailTips");
		ret.mailTips =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize(mailTipsJSON);
		JSONValue filterTypeJSON = json.get("filterType");
		ret.filterType =  new net.bluemind.mailmessage.api.gwt.serder.MailTipFilterFilterTypeGwtSerDer().deserialize(filterTypeJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.mailmessage.api.MailTipFilter o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.mailmessage.api.MailTipFilter o, JSONObject ret) {

		ret.put("mailTips",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( o.mailTips ));
		ret.put("filterType",  new net.bluemind.mailmessage.api.gwt.serder.MailTipFilterFilterTypeGwtSerDer().serialize( o.filterType ));
	}
}