/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2021
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.backend.mail.api;

import javax.ws.rs.POST;
import javax.ws.rs.Path;

import net.bluemind.core.api.BMApi;
import net.bluemind.core.task.api.TaskRef;

/**
 * Sync conversations internally between t_mailbox_record and t_conversation
 */
@BMApi(version = "3", internal = true)
@Path("/mail_conversation/{conversationContainer}")
public interface IMailConversationInternalSync {

	/**
	 * Sync conversations internally between t_mailbox_record and t_conversation
	 * 
	 * @return list of missing messages in t_conversation
	 */
	@POST
	@Path("_sync")
	public TaskRef sync(boolean dry);

}
