/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.directory.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class DirEntryQueryGwtSerDer implements GwtSerDer<net.bluemind.directory.api.DirEntryQuery> {

	public DirEntryQueryGwtSerDer( ) {
	}

	@Override
	public net.bluemind.directory.api.DirEntryQuery deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.directory.api.DirEntryQuery ret = new net.bluemind.directory.api.DirEntryQuery();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.directory.api.DirEntryQuery ret, JSONObject json) {

		JSONValue orderJSON = json.get("order");
		ret.order =  new net.bluemind.directory.api.gwt.serder.DirEntryQueryOrderGwtSerDer().deserialize(orderJSON);
		JSONValue nameFilterJSON = json.get("nameFilter");
		ret.nameFilter =  GwtSerDerUtils.STRING.deserialize(nameFilterJSON);
		JSONValue hiddenFilterJSON = json.get("hiddenFilter");
		ret.hiddenFilter =  GwtSerDerUtils.BOOLEAN.deserialize(hiddenFilterJSON);
		JSONValue emailFilterJSON = json.get("emailFilter");
		ret.emailFilter =  GwtSerDerUtils.STRING.deserialize(emailFilterJSON);
		JSONValue nameOrEmailFilterJSON = json.get("nameOrEmailFilter");
		ret.nameOrEmailFilter =  GwtSerDerUtils.STRING.deserialize(nameOrEmailFilterJSON);
		JSONValue stateFilterJSON = json.get("stateFilter");
		ret.stateFilter =  new net.bluemind.directory.api.gwt.serder.DirEntryQueryStateFilterGwtSerDer().deserialize(stateFilterJSON);
		JSONValue systemFilterJSON = json.get("systemFilter");
		ret.systemFilter =  GwtSerDerUtils.BOOLEAN.deserialize(systemFilterJSON);
		JSONValue kindsFilterJSON = json.get("kindsFilter");
		ret.kindsFilter =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.directory.api.gwt.serder.BaseDirEntryKindGwtSerDer()).deserialize(kindsFilterJSON);
		JSONValue entriesJSON = json.get("entries");
		ret.entries =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize(entriesJSON);
		JSONValue orgUnitIdsJSON = json.get("orgUnitIds");
		ret.orgUnitIds =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.LONG).deserialize(orgUnitIdsJSON);
		JSONValue accountTypeFilterJSON = json.get("accountTypeFilter");
		ret.accountTypeFilter =  new net.bluemind.directory.api.gwt.serder.BaseDirEntryAccountTypeGwtSerDer().deserialize(accountTypeFilterJSON);
		JSONValue fromJSON = json.get("from");
		ret.from =  GwtSerDerUtils.INT.deserialize(fromJSON);
		JSONValue sizeJSON = json.get("size");
		ret.size =  GwtSerDerUtils.INT.deserialize(sizeJSON);
		JSONValue entryUidFilterJSON = json.get("entryUidFilter");
		ret.entryUidFilter =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize(entryUidFilterJSON);
		JSONValue onlyManagableJSON = json.get("onlyManagable");
		ret.onlyManagable =  GwtSerDerUtils.BOOLEAN.deserialize(onlyManagableJSON);
		JSONValue dataLocationJSON = json.get("dataLocation");
		ret.dataLocation =  GwtSerDerUtils.STRING.deserialize(dataLocationJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.directory.api.DirEntryQuery o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.directory.api.DirEntryQuery o, JSONObject ret) {

		ret.put("order",  new net.bluemind.directory.api.gwt.serder.DirEntryQueryOrderGwtSerDer().serialize( o.order ));
		ret.put("nameFilter",  GwtSerDerUtils.STRING.serialize( o.nameFilter ));
		ret.put("hiddenFilter",  GwtSerDerUtils.BOOLEAN.serialize( o.hiddenFilter ));
		ret.put("emailFilter",  GwtSerDerUtils.STRING.serialize( o.emailFilter ));
		ret.put("nameOrEmailFilter",  GwtSerDerUtils.STRING.serialize( o.nameOrEmailFilter ));
		ret.put("stateFilter",  new net.bluemind.directory.api.gwt.serder.DirEntryQueryStateFilterGwtSerDer().serialize( o.stateFilter ));
		ret.put("systemFilter",  GwtSerDerUtils.BOOLEAN.serialize( o.systemFilter ));
		ret.put("kindsFilter",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.directory.api.gwt.serder.BaseDirEntryKindGwtSerDer()).serialize( o.kindsFilter ));
		ret.put("entries",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( o.entries ));
		ret.put("orgUnitIds",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.LONG).serialize( o.orgUnitIds ));
		ret.put("accountTypeFilter",  new net.bluemind.directory.api.gwt.serder.BaseDirEntryAccountTypeGwtSerDer().serialize( o.accountTypeFilter ));
		ret.put("from",  GwtSerDerUtils.INT.serialize( o.from ));
		ret.put("size",  GwtSerDerUtils.INT.serialize( o.size ));
		ret.put("entryUidFilter",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( o.entryUidFilter ));
		ret.put("onlyManagable",  GwtSerDerUtils.BOOLEAN.serialize( o.onlyManagable ));
		ret.put("dataLocation",  GwtSerDerUtils.STRING.serialize( o.dataLocation ));
	}
}