/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.icalendar.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ICalendarElementRRuleWeekDayGwtSerDer implements GwtSerDer<net.bluemind.icalendar.api.ICalendarElement.RRule.WeekDay> {

	public ICalendarElementRRuleWeekDayGwtSerDer( ) {
	}

	@Override
	public net.bluemind.icalendar.api.ICalendarElement.RRule.WeekDay deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.icalendar.api.ICalendarElement.RRule.WeekDay ret = new net.bluemind.icalendar.api.ICalendarElement.RRule.WeekDay();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.icalendar.api.ICalendarElement.RRule.WeekDay ret, JSONObject json) {

		JSONValue dayJSON = json.get("day");
		ret.day =  GwtSerDerUtils.STRING.deserialize(dayJSON);
		JSONValue offsetJSON = json.get("offset");
		ret.offset =  GwtSerDerUtils.INT.deserialize(offsetJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.icalendar.api.ICalendarElement.RRule.WeekDay o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.icalendar.api.ICalendarElement.RRule.WeekDay o, JSONObject ret) {

		ret.put("day",  GwtSerDerUtils.STRING.serialize( o.day ));
		ret.put("offset",  GwtSerDerUtils.INT.serialize( o.offset ));
	}
}