/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailflow.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MailRuleDescriptorGwtSerDer implements GwtSerDer<net.bluemind.mailflow.api.MailRuleDescriptor> {

	public MailRuleDescriptorGwtSerDer( ) {
	}

	@Override
	public net.bluemind.mailflow.api.MailRuleDescriptor deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.mailflow.api.MailRuleDescriptor ret = new net.bluemind.mailflow.api.MailRuleDescriptor();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.mailflow.api.MailRuleDescriptor ret, JSONObject json) {

		JSONValue ruleIdentifierJSON = json.get("ruleIdentifier");
		ret.ruleIdentifier =  GwtSerDerUtils.STRING.deserialize(ruleIdentifierJSON);
		JSONValue descriptionJSON = json.get("description");
		ret.description =  GwtSerDerUtils.STRING.deserialize(descriptionJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.mailflow.api.MailRuleDescriptor o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.mailflow.api.MailRuleDescriptor o, JSONObject ret) {

		ret.put("ruleIdentifier",  GwtSerDerUtils.STRING.serialize( o.ruleIdentifier ));
		ret.put("description",  GwtSerDerUtils.STRING.serialize( o.description ));
	}
}