/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailbox.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;

public class MailboxesSockJsEndpoint implements net.bluemind.mailbox.api.IMailboxesAsync {

	private String rootUri = "/api";

	private String baseUri;

    private String sessionId;

	public MailboxesSockJsEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/mailboxes/{domainUid}";
		this.sessionId = sessionId;
	
		uri_ = uri_.replace("{domainUid}",pathVars[0]);
		
		baseUri = uri_;
	}

	public MailboxesSockJsEndpoint withRoot(String root) {
		this.rootUri = root;
		return this;
	}

	@Override
	public void getMailboxConfig(String uid, final AsyncHandler<net.bluemind.mailbox.api.MailboxConfig> handler) {
		String postUri = "/{uid}/_config";

		postUri = postUri.replace("{uid}", ""+uid);
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.mailbox.api.MailboxConfig>(handler) {
					@Override
			protected net.bluemind.mailbox.api.MailboxConfig handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.mailbox.api.gwt.serder.MailboxConfigGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void update(String uid, net.bluemind.mailbox.api.Mailbox mailbox, final AsyncHandler<Void> handler) {
		String postUri = "/{uid}";

		postUri = postUri.replace("{uid}", ""+uid);
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.mailbox.api.gwt.serder.MailboxGwtSerDer().serialize( mailbox);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void byName(String name, final AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>> handler) {
		String postUri = "/_byname";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("name", ""+name);
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>(handler) {
					@Override
			protected net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.mailbox.api.gwt.serder.MailboxGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void delete(String uid, final AsyncHandler<Void> handler) {
		String postUri = "/{uid}";

		postUri = postUri.replace("{uid}", ""+uid);
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"DELETE",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void setMailboxFilter(String mailboxUid, net.bluemind.mailbox.api.MailFilter filter, final AsyncHandler<Void> handler) {
		String postUri = "/{mailboxUid}/_filter";

		postUri = postUri.replace("{mailboxUid}", ""+mailboxUid);
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.mailbox.api.gwt.serder.MailFilterGwtSerDer().serialize( filter);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void getUnreadMessagesCount(final AsyncHandler<Integer> handler) {
		String postUri = "/_unread";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Integer>(handler) {
					@Override
			protected Integer handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.INT.deserialize( jsonValue );
			}
		});

	}


	@Override
	public void listUids(final AsyncHandler<List<String>> handler) {
		String postUri = "/_listUids";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<String>>(handler) {
					@Override
			protected List<String> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void setMailboxAccessControlList(String mailboxUid, List<net.bluemind.core.container.model.acl.AccessControlEntry> accessControlEntries, final AsyncHandler<Void> handler) {
		String postUri = "/{mailboxUid}/_acls";

		postUri = postUri.replace("{mailboxUid}", ""+mailboxUid);
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.acl.gwt.serder.AccessControlEntryGwtSerDer()).serialize( accessControlEntries);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void byEmail(String email, final AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>> handler) {
		String postUri = "/_byemail";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("email", ""+email);
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>(handler) {
					@Override
			protected net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.mailbox.api.gwt.serder.MailboxGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void create(String uid, net.bluemind.mailbox.api.Mailbox mailbox, final AsyncHandler<Void> handler) {
		String postUri = "/{uid}";

		postUri = postUri.replace("{uid}", ""+uid);
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.mailbox.api.gwt.serder.MailboxGwtSerDer().serialize( mailbox);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"PUT",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void byRouting(net.bluemind.mailbox.api.Mailbox.Routing email, final AsyncHandler<List<String>> handler) {
		String postUri = "/_byRouting";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("email", ""+email);
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<String>>(handler) {
					@Override
			protected List<String> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void checkAll(final AsyncHandler<net.bluemind.core.task.api.TaskRef> handler) {
		String postUri = "/_check-all";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.task.api.TaskRef>(handler) {
					@Override
			protected net.bluemind.core.task.api.TaskRef handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.task.api.gwt.serder.TaskRefGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void multipleGet(List<String> uids, final AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>> handler) {
		String postUri = "/_mget";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( uids);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>>(handler) {
					@Override
			protected List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.mailbox.api.gwt.serder.MailboxGwtSerDer())).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void checkAndRepair(String uid, final AsyncHandler<net.bluemind.core.task.api.TaskRef> handler) {
		String postUri = "/{uid}/_check-and-repair";

		postUri = postUri.replace("{uid}", ""+uid);
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.task.api.TaskRef>(handler) {
					@Override
			protected net.bluemind.core.task.api.TaskRef handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.task.api.gwt.serder.TaskRefGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getMailboxFilter(String mailboxUid, final AsyncHandler<net.bluemind.mailbox.api.MailFilter> handler) {
		String postUri = "/{mailboxUid}/_filter";

		postUri = postUri.replace("{mailboxUid}", ""+mailboxUid);
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.mailbox.api.MailFilter>(handler) {
					@Override
			protected net.bluemind.mailbox.api.MailFilter handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.mailbox.api.gwt.serder.MailFilterGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getMailboxAccessControlList(String mailboxUid, final AsyncHandler<List<net.bluemind.core.container.model.acl.AccessControlEntry>> handler) {
		String postUri = "/{mailboxUid}/_acls";

		postUri = postUri.replace("{mailboxUid}", ""+mailboxUid);
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<net.bluemind.core.container.model.acl.AccessControlEntry>>(handler) {
					@Override
			protected List<net.bluemind.core.container.model.acl.AccessControlEntry> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.acl.gwt.serder.AccessControlEntryGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void check(String uid, final AsyncHandler<net.bluemind.core.task.api.TaskRef> handler) {
		String postUri = "/{uid}/_check";

		postUri = postUri.replace("{uid}", ""+uid);
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.task.api.TaskRef>(handler) {
					@Override
			protected net.bluemind.core.task.api.TaskRef handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.task.api.gwt.serder.TaskRefGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void list(final AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>> handler) {
		String postUri = "/_list";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>>(handler) {
					@Override
			protected List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.mailbox.api.gwt.serder.MailboxGwtSerDer())).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void setDomainFilter(net.bluemind.mailbox.api.MailFilter filter, final AsyncHandler<Void> handler) {
		String postUri = "/_filter";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.mailbox.api.gwt.serder.MailFilterGwtSerDer().serialize( filter);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void getMailboxQuota(String uid, final AsyncHandler<net.bluemind.mailbox.api.MailboxQuota> handler) {
		String postUri = "/{uid}/_quota";

		postUri = postUri.replace("{uid}", ""+uid);
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.mailbox.api.MailboxQuota>(handler) {
					@Override
			protected net.bluemind.mailbox.api.MailboxQuota handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.mailbox.api.gwt.serder.MailboxQuotaGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getComplete(String uid, final AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>> handler) {
		String postUri = "/{uid}/complete";

		postUri = postUri.replace("{uid}", ""+uid);
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>(handler) {
					@Override
			protected net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.mailbox.api.gwt.serder.MailboxGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getDomainFilter(final AsyncHandler<net.bluemind.mailbox.api.MailFilter> handler) {
		String postUri = "/_filter";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.mailbox.api.MailFilter>(handler) {
					@Override
			protected net.bluemind.mailbox.api.MailFilter handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.mailbox.api.gwt.serder.MailFilterGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void byType(net.bluemind.mailbox.api.Mailbox.Type email, final AsyncHandler<List<String>> handler) {
		String postUri = "/_byType";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("email", ""+email);
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<String>>(handler) {
					@Override
			protected List<String> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void checkAndRepairAll(final AsyncHandler<net.bluemind.core.task.api.TaskRef> handler) {
		String postUri = "/_check-and-repair-all";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.task.api.TaskRef>(handler) {
					@Override
			protected net.bluemind.core.task.api.TaskRef handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.task.api.gwt.serder.TaskRefGwtSerDer().deserialize( jsonValue );
			}
		});

	}

	public net.bluemind.mailbox.api.IMailboxesPromise promiseApi() {
		return new MailboxesEndpointPromise(this);
	}

}
