/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.metrics.alerts.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class ProductChecksEndpointPromise implements net.bluemind.metrics.alerts.api.IProductChecksPromise {

	private net.bluemind.metrics.alerts.api.IProductChecksAsync impl;

	public ProductChecksEndpointPromise(net.bluemind.metrics.alerts.api.IProductChecksAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<Set<String>> availableChecks() {
		
		CompletableFuture<Set<String>> ret = new CompletableFuture<Set<String>>();
		AsyncHandler<Set<String>> handler = new AsyncHandler<Set<String>>() {
			public void success(Set<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.availableChecks( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.metrics.alerts.api.CheckResult> lastResult(String checkName  ) {
		
		CompletableFuture<net.bluemind.metrics.alerts.api.CheckResult> ret = new CompletableFuture<net.bluemind.metrics.alerts.api.CheckResult>();
		AsyncHandler<net.bluemind.metrics.alerts.api.CheckResult> handler = new AsyncHandler<net.bluemind.metrics.alerts.api.CheckResult>() {
			public void success(net.bluemind.metrics.alerts.api.CheckResult value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.lastResult(checkName,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.task.api.TaskRef> check(String checkName  ) {
		
		CompletableFuture<net.bluemind.core.task.api.TaskRef> ret = new CompletableFuture<net.bluemind.core.task.api.TaskRef>();
		AsyncHandler<net.bluemind.core.task.api.TaskRef> handler = new AsyncHandler<net.bluemind.core.task.api.TaskRef>() {
			public void success(net.bluemind.core.task.api.TaskRef value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.check(checkName,  handler);
		return ret;
	}

}
