/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.metrics.alerts.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.json.client.JSONValue;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;

public class MonitoringGwtEndpoint implements net.bluemind.metrics.alerts.api.IMonitoringAsync {

	private String baseUri;

	private String sessionId;

	private String root = "/api";

	public MonitoringGwtEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/monitoring";
		this.sessionId = sessionId;
	

		baseUri = uri_;
	}

	public MonitoringGwtEndpoint withRoot(String root) {
		this.root = root;
		return this;
	}

	@Override
	public void getAlerts(int limit, boolean filterResolved, List<net.bluemind.metrics.alerts.api.AlertLevel> levels, final AsyncHandler<List<net.bluemind.metrics.alerts.api.AlertInfo>> handler) {
		String postUri = "";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&limit=" + com.google.gwt.http.client.URL.encodeQueryString(""+limit);
		queryParams += "&filterResolved=" + com.google.gwt.http.client.URL.encodeQueryString(""+filterResolved);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(new net.bluemind.metrics.alerts.api.gwt.serder.AlertLevelGwtSerDer()).serialize( levels);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<net.bluemind.metrics.alerts.api.AlertInfo>>(handler) {
			@Override
			protected List<net.bluemind.metrics.alerts.api.AlertInfo> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.metrics.alerts.api.gwt.serder.AlertInfoGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}

	public net.bluemind.metrics.alerts.api.IMonitoringPromise promiseApi() {
		return new MonitoringEndpointPromise(this);
	}
}
