/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.user.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class UserMailIdentityGwtSerDer implements GwtSerDer<net.bluemind.user.api.UserMailIdentity> {

    private net.bluemind.mailbox.identity.api.gwt.serder.IdentityGwtSerDer parent = new  net.bluemind.mailbox.identity.api.gwt.serder.IdentityGwtSerDer(); 
	public UserMailIdentityGwtSerDer( ) {
	}

	@Override
	public net.bluemind.user.api.UserMailIdentity deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.user.api.UserMailIdentity ret = new net.bluemind.user.api.UserMailIdentity();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.user.api.UserMailIdentity ret, JSONObject json) {
		parent.deserializeTo( ret, json);

		JSONValue mailboxUidJSON = json.get("mailboxUid");
		ret.mailboxUid =  GwtSerDerUtils.STRING.deserialize(mailboxUidJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.user.api.UserMailIdentity o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.user.api.UserMailIdentity o, JSONObject ret) {
		parent.serializeTo( o, ret);

		ret.put("mailboxUid",  GwtSerDerUtils.STRING.serialize( o.mailboxUid ));
	}
}