/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.model.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ItemContainerValueGwtSerDer<T> implements GwtSerDer<net.bluemind.core.container.model.ItemContainerValue<T>> {

	private GwtSerDer<T> paramSerDerT;

	public ItemContainerValueGwtSerDer(GwtSerDer<T> paramSerDerT ) {
		this.paramSerDerT = paramSerDerT;
	}

	@Override
	public net.bluemind.core.container.model.ItemContainerValue<T> deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.core.container.model.ItemContainerValue<T> ret = new net.bluemind.core.container.model.ItemContainerValue<T>();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.core.container.model.ItemContainerValue<T> ret, JSONObject json) {

		JSONValue containerUidJSON = json.get("containerUid");
		ret.containerUid =  GwtSerDerUtils.STRING.deserialize(containerUidJSON);
		JSONValue valueJSON = json.get("value");
		ret.value =  paramSerDerT.deserialize(valueJSON);
		JSONValue uidJSON = json.get("uid");
		ret.uid =  GwtSerDerUtils.STRING.deserialize(uidJSON);
		JSONValue versionJSON = json.get("version");
		ret.version =  GwtSerDerUtils.LONG.deserialize(versionJSON);
		JSONValue displayNameJSON = json.get("displayName");
		ret.displayName =  GwtSerDerUtils.STRING.deserialize(displayNameJSON);
		JSONValue externalIdJSON = json.get("externalId");
		ret.externalId =  GwtSerDerUtils.STRING.deserialize(externalIdJSON);
		JSONValue createdByJSON = json.get("createdBy");
		ret.createdBy =  GwtSerDerUtils.STRING.deserialize(createdByJSON);
		JSONValue updatedByJSON = json.get("updatedBy");
		ret.updatedBy =  GwtSerDerUtils.STRING.deserialize(updatedByJSON);
		JSONValue createdJSON = json.get("created");
		ret.created =  GwtSerDerUtils.DATE.deserialize(createdJSON);
		JSONValue updatedJSON = json.get("updated");
		ret.updated =  GwtSerDerUtils.DATE.deserialize(updatedJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.core.container.model.ItemContainerValue<T> o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.core.container.model.ItemContainerValue<T> o, JSONObject ret) {

		ret.put("containerUid",  GwtSerDerUtils.STRING.serialize( o.containerUid ));
		ret.put("value",  paramSerDerT.serialize( o.value ));
		ret.put("uid",  GwtSerDerUtils.STRING.serialize( o.uid ));
		ret.put("version",  GwtSerDerUtils.LONG.serialize( o.version ));
		ret.put("displayName",  GwtSerDerUtils.STRING.serialize( o.displayName ));
		ret.put("externalId",  GwtSerDerUtils.STRING.serialize( o.externalId ));
		ret.put("createdBy",  GwtSerDerUtils.STRING.serialize( o.createdBy ));
		ret.put("updatedBy",  GwtSerDerUtils.STRING.serialize( o.updatedBy ));
		ret.put("created",  GwtSerDerUtils.DATE.serialize( o.created ));
		ret.put("updated",  GwtSerDerUtils.DATE.serialize( o.updated ));
	}
}