/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.model.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ContainerUpdatesResultGwtSerDer implements GwtSerDer<net.bluemind.core.container.model.ContainerUpdatesResult> {

	public ContainerUpdatesResultGwtSerDer( ) {
	}

	@Override
	public net.bluemind.core.container.model.ContainerUpdatesResult deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.core.container.model.ContainerUpdatesResult ret = new net.bluemind.core.container.model.ContainerUpdatesResult();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.core.container.model.ContainerUpdatesResult ret, JSONObject json) {

		JSONValue addedJSON = json.get("added");
		ret.added =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize(addedJSON);
		JSONValue updatedJSON = json.get("updated");
		ret.updated =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize(updatedJSON);
		JSONValue removedJSON = json.get("removed");
		ret.removed =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize(removedJSON);
		JSONValue unhandledJSON = json.get("unhandled");
		ret.unhandled =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize(unhandledJSON);
		JSONValue errorsJSON = json.get("errors");
		ret.errors =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ContainerUpdatesResultInErrorGwtSerDer()).deserialize(errorsJSON);
		JSONValue versionJSON = json.get("version");
		ret.version =  GwtSerDerUtils.LONG.deserialize(versionJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.core.container.model.ContainerUpdatesResult o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.core.container.model.ContainerUpdatesResult o, JSONObject ret) {

		ret.put("added",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( o.added ));
		ret.put("updated",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( o.updated ));
		ret.put("removed",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( o.removed ));
		ret.put("unhandled",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( o.unhandled ));
		ret.put("errors",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ContainerUpdatesResultInErrorGwtSerDer()).serialize( o.errors ));
		ret.put("version",  GwtSerDerUtils.LONG.serialize( o.version ));
	}
}