/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.model.acl.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class AccessControlEntryGwtSerDer implements GwtSerDer<net.bluemind.core.container.model.acl.AccessControlEntry> {

	public AccessControlEntryGwtSerDer( ) {
	}

	@Override
	public net.bluemind.core.container.model.acl.AccessControlEntry deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.core.container.model.acl.AccessControlEntry ret = new net.bluemind.core.container.model.acl.AccessControlEntry();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.core.container.model.acl.AccessControlEntry ret, JSONObject json) {

		JSONValue subjectJSON = json.get("subject");
		ret.subject =  GwtSerDerUtils.STRING.deserialize(subjectJSON);
		JSONValue verbJSON = json.get("verb");
		ret.verb =  new net.bluemind.core.container.model.acl.gwt.serder.VerbGwtSerDer().deserialize(verbJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.core.container.model.acl.AccessControlEntry o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.core.container.model.acl.AccessControlEntry o, JSONObject ret) {

		ret.put("subject",  GwtSerDerUtils.STRING.serialize( o.subject ));
		ret.put("verb",  new net.bluemind.core.container.model.acl.gwt.serder.VerbGwtSerDer().serialize( o.verb ));
	}
}