/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.json.client.JSONValue;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;

public class OfflineMgmtGwtEndpoint implements net.bluemind.core.container.api.IOfflineMgmtAsync {

	private String baseUri;

	private String sessionId;

	private String root = "/api";

	public OfflineMgmtGwtEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/offline/{domainUid}/{ownerUid}";
		this.sessionId = sessionId;
	
		uri_ = uri_.replace("{domainUid}",pathVars[0]);
				uri_ = uri_.replace("{ownerUid}",pathVars[1]);
		
		baseUri = uri_;
	}

	public OfflineMgmtGwtEndpoint withRoot(String root) {
		this.root = root;
		return this;
	}

	@Override
	public void allocateOfflineIds(int idCount, final AsyncHandler<net.bluemind.core.container.api.IdRange> handler) {
		String postUri = "/_allocateOfflineIds";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&idCount=" + com.google.gwt.http.client.URL.encodeQueryString(""+idCount);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.api.IdRange>(handler) {
			@Override
			protected net.bluemind.core.container.api.IdRange handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.api.gwt.serder.IdRangeGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}

	public net.bluemind.core.container.api.IOfflineMgmtPromise promiseApi() {
		return new OfflineMgmtEndpointPromise(this);
	}
}
