/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.config.provider;

import io.sentry.config.provider.ConfigurationProvider;
import io.sentry.util.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemPropertiesConfigurationProvider
implements ConfigurationProvider {
    public static final String DEFAULT_SYSTEM_PROPERTY_PREFIX = "sentry.";
    private static final Logger logger = LoggerFactory.getLogger(SystemPropertiesConfigurationProvider.class);
    private final String prefix;

    public SystemPropertiesConfigurationProvider() {
        this(DEFAULT_SYSTEM_PROPERTY_PREFIX);
    }

    public SystemPropertiesConfigurationProvider(String systemPropertyPrefix) {
        this.prefix = systemPropertyPrefix;
    }

    @Override
    @Nullable
    public String getProperty(String key) {
        String ret = System.getProperty(this.prefix + key.toLowerCase());
        if (ret != null) {
            logger.debug("Found {}={} in Java System Properties.", (Object)key, (Object)ret);
        }
        return ret;
    }
}

