/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.querycache.subscriber;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ContinuousQueryMadePublishableCodec;
import com.hazelcast.client.impl.protocol.codec.ContinuousQueryPublisherCreateCodec;
import com.hazelcast.client.impl.protocol.codec.ContinuousQueryPublisherCreateWithValueCodec;
import com.hazelcast.map.impl.querycache.InvokerWrapper;
import com.hazelcast.map.impl.querycache.accumulator.AccumulatorInfo;
import com.hazelcast.map.impl.querycache.subscriber.AbstractQueryCacheEndToEndConstructor;
import com.hazelcast.map.impl.querycache.subscriber.InternalQueryCache;
import com.hazelcast.map.impl.querycache.subscriber.QueryCacheRequest;
import com.hazelcast.nio.serialization.Data;

public class ClientQueryCacheEndToEndConstructor
extends AbstractQueryCacheEndToEndConstructor {
    public ClientQueryCacheEndToEndConstructor(QueryCacheRequest request) {
        super(request);
    }

    public void createPublisherAccumulator(AccumulatorInfo info) throws Exception {
        ClientMessage publisherCreateMessage = this.newPublisherCreateMessage(info);
        InvokerWrapper invokerWrapper = this.context.getInvokerWrapper();
        ClientMessage response = (ClientMessage)invokerWrapper.invoke((Object)publisherCreateMessage);
        ClientQueryCacheEndToEndConstructor.prepopulate(this.queryCache, response, info.isIncludeValue());
        if (info.isPopulate()) {
            this.madePublishable(info.getMapName(), info.getCacheId());
            info.setPublishable(true);
        }
    }

    private ClientMessage newPublisherCreateMessage(AccumulatorInfo info) {
        Data dataPredicate = this.context.getSerializationService().toData((Object)info.getPredicate());
        if (info.isIncludeValue()) {
            return ContinuousQueryPublisherCreateWithValueCodec.encodeRequest((String)info.getMapName(), (String)info.getCacheId(), (Data)dataPredicate, (int)info.getBatchSize(), (int)info.getBufferSize(), (long)info.getDelaySeconds(), (boolean)info.isPopulate(), (boolean)info.isCoalesce());
        }
        return ContinuousQueryPublisherCreateCodec.encodeRequest((String)info.getMapName(), (String)info.getCacheId(), (Data)dataPredicate, (int)info.getBatchSize(), (int)info.getBufferSize(), (long)info.getDelaySeconds(), (boolean)info.isPopulate(), (boolean)info.isCoalesce());
    }

    private void madePublishable(String mapName, String cacheName) throws Exception {
        ClientMessage request = ContinuousQueryMadePublishableCodec.encodeRequest((String)mapName, (String)cacheName);
        this.context.getInvokerWrapper().invokeOnAllPartitions((Object)request);
    }

    private static void prepopulate(InternalQueryCache queryCache, ClientMessage clientMessage, boolean includeValue) {
        int responseSize = clientMessage.getInt();
        for (int responseIndex = 0; responseIndex < responseSize && !queryCache.reachedMaxCapacity(); ++responseIndex) {
            Data dataKey = clientMessage.getData();
            Data dataValue = includeValue ? clientMessage.getData() : null;
            queryCache.prepopulate((Object)dataKey, (Object)dataValue);
        }
    }
}

