/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.codec;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.mail.internet.MimeUtility;
import org.apache.james.mime4j.codec.Base64InputStream;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.codec.QuotedPrintableInputStream;

public class DecoderUtil {
    private static byte[] decodeQuotedPrintable(String s, DecodeMonitor monitor) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            byte[] bytes = s.getBytes("US-ASCII");
            QuotedPrintableInputStream is = new QuotedPrintableInputStream((InputStream)new ByteArrayInputStream(bytes), monitor);
            int b = 0;
            while ((b = is.read()) != -1) {
                baos.write(b);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return baos.toByteArray();
    }

    private static byte[] decodeBase64(String s, DecodeMonitor monitor) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            byte[] bytes = s.getBytes("US-ASCII");
            Base64InputStream is = new Base64InputStream((InputStream)new ByteArrayInputStream(bytes), monitor);
            int b = 0;
            while ((b = is.read()) != -1) {
                baos.write(b);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return baos.toByteArray();
    }

    static String decodeB(String encodedText, String charset, DecodeMonitor monitor) throws UnsupportedEncodingException {
        byte[] decodedBytes = DecoderUtil.decodeBase64(encodedText, monitor);
        return new String(decodedBytes, charset);
    }

    static String decodeQ(String encodedText, String charset, DecodeMonitor monitor) throws UnsupportedEncodingException {
        encodedText = DecoderUtil.replaceUnderscores(encodedText);
        byte[] decodedBytes = DecoderUtil.decodeQuotedPrintable(encodedText, monitor);
        return new String(decodedBytes, charset);
    }

    static String decodeEncodedWords(String body) {
        return DecoderUtil.decodeEncodedWords(body, DecodeMonitor.SILENT);
    }

    public static String decodeEncodedWords(String body, DecodeMonitor monitor) throws IllegalArgumentException {
        try {
            return MimeUtility.decodeText((String)body);
        }
        catch (UnsupportedEncodingException e) {
            if (monitor.isListening()) {
                throw new IllegalArgumentException(e);
            }
            return body;
        }
    }

    private static String replaceUnderscores(String str) {
        StringBuilder sb = new StringBuilder(128);
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '_') {
                sb.append("=20");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

