package net.bluemind.directory.api;
import net.bluemind.core.api.BMPromiseApi;
import java.util.concurrent.CompletableFuture;

@BMPromiseApi(net.bluemind.directory.api.IDirectoryAsync.class)
public interface IDirectoryPromise  {

	CompletableFuture<byte[]> getEntryIcon(java.lang.String entryUid);

	CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.addressbook.api.VCard>> getVCard(java.lang.String uid);

	CompletableFuture<net.bluemind.core.task.api.TaskRef> delete(java.lang.String path);

	CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<java.lang.String>> changeset(java.lang.Long since);

	CompletableFuture<java.util.List<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.DirEntry>>> getByRoles(java.util.List<java.lang.String> roles);

	CompletableFuture<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.DirEntry>>> search(net.bluemind.directory.api.DirEntryQuery query);

	CompletableFuture<net.bluemind.directory.api.DirEntry> findByEntryUid(java.lang.String entryUid);

	CompletableFuture<java.util.List<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.DirEntry>>> getMultiple(java.util.List<java.lang.String> id);

	CompletableFuture<byte[]> getEntryPhoto(java.lang.String entryUid);

	CompletableFuture<net.bluemind.directory.api.DirEntry> getEntry(java.lang.String path);

	CompletableFuture<net.bluemind.directory.api.DirEntry> getRoot();

	CompletableFuture<net.bluemind.core.task.api.TaskRef> deleteByEntryUid(java.lang.String entryUid);

	CompletableFuture<net.bluemind.core.task.api.TaskRef> xfer(java.lang.String entryUid, java.lang.String serverUid);

	CompletableFuture<net.bluemind.directory.api.DirEntry> getByEmail(java.lang.String email);

	CompletableFuture<java.util.Set<java.lang.String>> getRolesForDirEntry(java.lang.String entryUid);

	CompletableFuture<net.bluemind.core.container.model.ContainerChangelog> changelog(java.lang.Long since);

	CompletableFuture<java.util.Set<java.lang.String>> getRolesForOrgUnit(java.lang.String ouUid);

	CompletableFuture<byte[]> getIcon(java.lang.String path);

	CompletableFuture<java.util.List<net.bluemind.directory.api.DirEntry>> getEntries(java.lang.String path);

}