package net.bluemind.backend.mail.api;
import net.bluemind.core.api.BMPromiseApi;
import java.util.concurrent.CompletableFuture;

@BMPromiseApi(net.bluemind.backend.mail.api.IMailboxFoldersByContainerAsync.class)
public interface IMailboxFoldersByContainerPromise  {

	CompletableFuture<Long> getVersion();

	CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>> filteredChangesetById(java.lang.Long since, net.bluemind.core.container.model.ItemFlagFilter arg1);

	CompletableFuture<net.bluemind.core.container.model.ItemChangelog> itemChangelog(java.lang.String uid, java.lang.Long arg1);

	CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<java.lang.String>> changeset(java.lang.Long since);

	CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<java.lang.Long>> changesetById(java.lang.Long since);

	CompletableFuture<net.bluemind.core.container.model.ContainerChangelog> containerChangelog(java.lang.Long arg0);

	CompletableFuture<net.bluemind.core.api.ListResult<java.lang.Long>> allIds(java.lang.String filter, java.lang.Long knownContainerVersion, java.lang.Integer limit, java.lang.Integer offset);

	CompletableFuture<java.util.List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>> all();

	CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> byName(java.lang.String name);

	CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> getComplete(java.lang.String uid);

	CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> root();

	CompletableFuture<net.bluemind.backend.mail.api.SearchResult> searchItems(net.bluemind.backend.mail.api.MailboxFolderSearchQuery query);

	CompletableFuture<java.util.List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>> multipleGetById(java.util.List<java.lang.Long> arg0);

	CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> getCompleteById(long id);

	CompletableFuture<net.bluemind.backend.mail.api.ImportMailboxItemsStatus> importItems(long folderDestinationId, net.bluemind.backend.mail.api.ImportMailboxItemSet mailboxItems);

	CompletableFuture<Void> emptyFolder(long id);

	CompletableFuture<Void> removeMessages(long id);

	CompletableFuture<Void> markFolderAsRead(long id);

	CompletableFuture<net.bluemind.core.container.model.ItemIdentifier> createBasic(net.bluemind.backend.mail.api.MailboxFolder value);

	CompletableFuture<net.bluemind.core.container.model.ItemIdentifier> createForHierarchy(long hierarchyId, net.bluemind.backend.mail.api.MailboxFolder value);

	CompletableFuture<net.bluemind.core.container.api.Ack> updateById(long id, net.bluemind.backend.mail.api.MailboxFolder value);

	CompletableFuture<Void> deleteById(long id);

	CompletableFuture<Void> deepDelete(long id);

}