package net.bluemind.system.api.hot.upgrade;

import java.util.Collections;
import java.util.List;

import net.bluemind.core.api.BMApi;

@BMApi(version = "3")
public class HotUpgradeTaskExcludeOperationFilter {
	public List<String> excludedOperations;
	public List<HotUpgradeTaskStatus> statuses;

	private HotUpgradeTaskExcludeOperationFilter(List<String> excludedOperations, List<HotUpgradeTaskStatus> statuses) {
		this.excludedOperations = Collections.unmodifiableList(excludedOperations);
		this.statuses = Collections.unmodifiableList(statuses);
	}

	public HotUpgradeTaskExcludeOperationFilter() {
		this(Collections.emptyList(), Collections.emptyList());
	}

	public static HotUpgradeTaskExcludeOperationFilter filter(List<String> excludedOperations,
			List<HotUpgradeTaskStatus> statuses) {
		return new HotUpgradeTaskExcludeOperationFilter(excludedOperations, statuses);
	}

	public List<String> getOperations() {
		return excludedOperations;
	}

	public List<HotUpgradeTaskStatus> getStatuses() {
		return statuses;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("HotUpgradeTaskOperationFilter [statuses=").append(statuses).append(", excludedOperations=")
				.append(excludedOperations).append("]");
		return builder.toString();
	}

}
