/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2018
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.rest.base;

import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpHeaders;

public class RestHeaders {

	public static final CharSequence X_BM_ORIGIN = HttpHeaders.createOptimized("X-BM-Origin");
	public static final CharSequence X_FORWARDED_FOR = HttpHeaders.createOptimized("X-Forwarded-For");

	private RestHeaders() {

	}

	public static MultiMap newMultimap() {
		return MultiMap.caseInsensitiveMultiMap();
	}

}
