package net.bluemind.user.api;
import net.bluemind.core.api.BMPromiseApi;
import java.util.concurrent.CompletableFuture;

@BMPromiseApi(net.bluemind.user.api.IUserAsync.class)
public interface IUserPromise  {

	CompletableFuture<byte[]> getPhoto(java.lang.String uid);

	CompletableFuture<Void> deletePhoto(java.lang.String uid);

	CompletableFuture<byte[]> getIcon(java.lang.String uid);

	CompletableFuture<Void> setPhoto(java.lang.String uid, byte[] arg1);

	CompletableFuture<Void> setExtId(java.lang.String uid, java.lang.String arg1);

	CompletableFuture<java.util.List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>> memberOf(java.lang.String uid);

	CompletableFuture<java.util.List<java.lang.String>> memberOfGroups(java.lang.String uid);

	CompletableFuture<Void> setPassword(java.lang.String uid, net.bluemind.user.api.ChangePassword password);

	CompletableFuture<java.util.List<java.lang.String>> allUids();

	CompletableFuture<Void> update(java.lang.String uid, net.bluemind.user.api.User user);

	CompletableFuture<net.bluemind.addressbook.api.VCard> getVCard(java.lang.String uid);

	CompletableFuture<net.bluemind.core.task.api.TaskRef> delete(java.lang.String uid);

	CompletableFuture<Void> updateAccountType(java.lang.String uid, net.bluemind.directory.api.BaseDirEntry.AccountType accountType);

	CompletableFuture<java.util.Set<java.lang.String>> getResolvedRoles(java.lang.String uid);

	CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>> byLogin(java.lang.String login);

	CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>> byEmail(java.lang.String email);

	CompletableFuture<Void> create(java.lang.String uid, net.bluemind.user.api.User user);

	CompletableFuture<Void> setRoles(java.lang.String uid, java.util.Set<java.lang.String> roles);

	CompletableFuture<java.util.Set<java.lang.String>> getRoles(java.lang.String uid);

	CompletableFuture<Void> updateVCard(java.lang.String uid, net.bluemind.addressbook.api.VCard userVCard);

	CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>> byExtId(java.lang.String extid);

	CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>> getComplete(java.lang.String uid);

	CompletableFuture<java.util.Set<java.lang.String>> getUsersWithRoles(java.util.List<java.lang.String> roles);

	CompletableFuture<Void> createWithExtId(java.lang.String uid, java.lang.String extid, net.bluemind.user.api.User user);

}