/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.channel.uring;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.MessageSizeEstimator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.socket.SocketChannelConfig;
import io.netty.incubator.channel.uring.IOUringChannelOption;
import io.netty.incubator.channel.uring.IOUringSocketChannel;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.util.Map;

public final class IOUringSocketChannelConfig
extends DefaultChannelConfig
implements SocketChannelConfig {
    private volatile boolean allowHalfClosure;

    IOUringSocketChannelConfig(Channel channel) {
        super(channel);
        if (PlatformDependent.canEnableTcpNoDelayByDefault()) {
            this.setTcpNoDelay(true);
        }
    }

    @Override
    public Map<ChannelOption<?>, Object> getOptions() {
        return this.getOptions(super.getOptions(), ChannelOption.SO_RCVBUF, ChannelOption.SO_SNDBUF, ChannelOption.TCP_NODELAY, ChannelOption.SO_KEEPALIVE, ChannelOption.SO_REUSEADDR, ChannelOption.SO_LINGER, ChannelOption.IP_TOS, ChannelOption.ALLOW_HALF_CLOSURE, IOUringChannelOption.TCP_CORK, IOUringChannelOption.TCP_NOTSENT_LOWAT, IOUringChannelOption.TCP_KEEPCNT, IOUringChannelOption.TCP_KEEPIDLE, IOUringChannelOption.TCP_KEEPINTVL, IOUringChannelOption.TCP_QUICKACK, IOUringChannelOption.IP_TRANSPARENT, IOUringChannelOption.TCP_FASTOPEN_CONNECT);
    }

    @Override
    public <T> T getOption(ChannelOption<T> option) {
        if (option == ChannelOption.SO_RCVBUF) {
            return (T)Integer.valueOf(this.getReceiveBufferSize());
        }
        if (option == ChannelOption.SO_SNDBUF) {
            return (T)Integer.valueOf(this.getSendBufferSize());
        }
        if (option == ChannelOption.TCP_NODELAY) {
            return (T)Boolean.valueOf(this.isTcpNoDelay());
        }
        if (option == ChannelOption.SO_KEEPALIVE) {
            return (T)Boolean.valueOf(this.isKeepAlive());
        }
        if (option == ChannelOption.SO_REUSEADDR) {
            return (T)Boolean.valueOf(this.isReuseAddress());
        }
        if (option == ChannelOption.SO_LINGER) {
            return (T)Integer.valueOf(this.getSoLinger());
        }
        if (option == ChannelOption.IP_TOS) {
            return (T)Integer.valueOf(this.getTrafficClass());
        }
        if (option == ChannelOption.ALLOW_HALF_CLOSURE) {
            return (T)Boolean.valueOf(this.isAllowHalfClosure());
        }
        if (option == IOUringChannelOption.TCP_CORK) {
            return (T)Boolean.valueOf(this.isTcpCork());
        }
        if (option == IOUringChannelOption.TCP_NOTSENT_LOWAT) {
            return (T)Long.valueOf(this.getTcpNotSentLowAt());
        }
        if (option == IOUringChannelOption.TCP_KEEPIDLE) {
            return (T)Integer.valueOf(this.getTcpKeepIdle());
        }
        if (option == IOUringChannelOption.TCP_KEEPINTVL) {
            return (T)Integer.valueOf(this.getTcpKeepIntvl());
        }
        if (option == IOUringChannelOption.TCP_KEEPCNT) {
            return (T)Integer.valueOf(this.getTcpKeepCnt());
        }
        if (option == IOUringChannelOption.TCP_USER_TIMEOUT) {
            return (T)Integer.valueOf(this.getTcpUserTimeout());
        }
        if (option == IOUringChannelOption.TCP_QUICKACK) {
            return (T)Boolean.valueOf(this.isTcpQuickAck());
        }
        if (option == IOUringChannelOption.IP_TRANSPARENT) {
            return (T)Boolean.valueOf(this.isIpTransparent());
        }
        if (option == IOUringChannelOption.TCP_FASTOPEN_CONNECT) {
            return (T)Boolean.valueOf(this.isTcpFastOpenConnect());
        }
        return super.getOption(option);
    }

    @Override
    public <T> boolean setOption(ChannelOption<T> option, T value) {
        this.validate(option, value);
        if (option == ChannelOption.SO_RCVBUF) {
            this.setReceiveBufferSize((Integer)value);
        } else if (option == ChannelOption.SO_SNDBUF) {
            this.setSendBufferSize((Integer)value);
        } else if (option == ChannelOption.TCP_NODELAY) {
            this.setTcpNoDelay((Boolean)value);
        } else if (option == ChannelOption.SO_KEEPALIVE) {
            this.setKeepAlive((Boolean)value);
        } else if (option == ChannelOption.SO_REUSEADDR) {
            this.setReuseAddress((Boolean)value);
        } else if (option == ChannelOption.SO_LINGER) {
            this.setSoLinger((Integer)value);
        } else if (option == ChannelOption.IP_TOS) {
            this.setTrafficClass((Integer)value);
        } else if (option == ChannelOption.ALLOW_HALF_CLOSURE) {
            this.setAllowHalfClosure((Boolean)value);
        } else if (option == IOUringChannelOption.TCP_CORK) {
            this.setTcpCork((Boolean)value);
        } else if (option == IOUringChannelOption.TCP_NOTSENT_LOWAT) {
            this.setTcpNotSentLowAt((Long)value);
        } else if (option == IOUringChannelOption.TCP_KEEPIDLE) {
            this.setTcpKeepIdle((Integer)value);
        } else if (option == IOUringChannelOption.TCP_KEEPCNT) {
            this.setTcpKeepCnt((Integer)value);
        } else if (option == IOUringChannelOption.TCP_KEEPINTVL) {
            this.setTcpKeepIntvl((Integer)value);
        } else if (option == IOUringChannelOption.TCP_USER_TIMEOUT) {
            this.setTcpUserTimeout((Integer)value);
        } else if (option == IOUringChannelOption.IP_TRANSPARENT) {
            this.setIpTransparent((Boolean)value);
        } else if (option == IOUringChannelOption.TCP_QUICKACK) {
            this.setTcpQuickAck((Boolean)value);
        } else if (option == IOUringChannelOption.TCP_FASTOPEN_CONNECT) {
            this.setTcpFastOpenConnect((Boolean)value);
        } else {
            return super.setOption(option, value);
        }
        return true;
    }

    @Override
    public int getSendBufferSize() {
        try {
            return ((IOUringSocketChannel)this.channel).socket.getSendBufferSize();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    @Override
    public int getSoLinger() {
        try {
            return ((IOUringSocketChannel)this.channel).socket.getSoLinger();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    @Override
    public int getTrafficClass() {
        try {
            return ((IOUringSocketChannel)this.channel).socket.getTrafficClass();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    @Override
    public boolean isKeepAlive() {
        try {
            return ((IOUringSocketChannel)this.channel).socket.isKeepAlive();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    @Override
    public boolean isReuseAddress() {
        try {
            return ((IOUringSocketChannel)this.channel).socket.isReuseAddress();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    @Override
    public boolean isTcpNoDelay() {
        try {
            return ((IOUringSocketChannel)this.channel).socket.isTcpNoDelay();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    public boolean isTcpCork() {
        try {
            return ((IOUringSocketChannel)this.channel).socket.isTcpCork();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    public int getSoBusyPoll() {
        try {
            return ((IOUringSocketChannel)this.channel).socket.getSoBusyPoll();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    public long getTcpNotSentLowAt() {
        try {
            return ((IOUringSocketChannel)this.channel).socket.getTcpNotSentLowAt();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    public int getTcpKeepIdle() {
        try {
            return ((IOUringSocketChannel)this.channel).socket.getTcpKeepIdle();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    public int getTcpKeepIntvl() {
        try {
            return ((IOUringSocketChannel)this.channel).socket.getTcpKeepIntvl();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    public int getTcpKeepCnt() {
        try {
            return ((IOUringSocketChannel)this.channel).socket.getTcpKeepCnt();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    public int getTcpUserTimeout() {
        try {
            return ((IOUringSocketChannel)this.channel).socket.getTcpUserTimeout();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    @Override
    public IOUringSocketChannelConfig setKeepAlive(boolean keepAlive) {
        try {
            ((IOUringSocketChannel)this.channel).socket.setKeepAlive(keepAlive);
            return this;
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    @Override
    public IOUringSocketChannelConfig setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        return this;
    }

    @Override
    public IOUringSocketChannelConfig setReceiveBufferSize(int receiveBufferSize) {
        try {
            ((IOUringSocketChannel)this.channel).socket.setReceiveBufferSize(receiveBufferSize);
            return this;
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    @Override
    public IOUringSocketChannelConfig setReuseAddress(boolean reuseAddress) {
        try {
            ((IOUringSocketChannel)this.channel).socket.setReuseAddress(reuseAddress);
            return this;
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    @Override
    public IOUringSocketChannelConfig setSendBufferSize(int sendBufferSize) {
        try {
            ((IOUringSocketChannel)this.channel).socket.setSendBufferSize(sendBufferSize);
            return this;
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    @Override
    public int getReceiveBufferSize() {
        try {
            return ((IOUringSocketChannel)this.channel).socket.getReceiveBufferSize();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    @Override
    public IOUringSocketChannelConfig setSoLinger(int soLinger) {
        try {
            ((IOUringSocketChannel)this.channel).socket.setSoLinger(soLinger);
            return this;
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    @Override
    public IOUringSocketChannelConfig setTcpNoDelay(boolean tcpNoDelay) {
        try {
            ((IOUringSocketChannel)this.channel).socket.setTcpNoDelay(tcpNoDelay);
            return this;
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    public IOUringSocketChannelConfig setTcpCork(boolean tcpCork) {
        try {
            ((IOUringSocketChannel)this.channel).socket.setTcpCork(tcpCork);
            return this;
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    public IOUringSocketChannelConfig setSoBusyPoll(int loopMicros) {
        try {
            ((IOUringSocketChannel)this.channel).socket.setSoBusyPoll(loopMicros);
            return this;
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    public IOUringSocketChannelConfig setTcpNotSentLowAt(long tcpNotSentLowAt) {
        try {
            ((IOUringSocketChannel)this.channel).socket.setTcpNotSentLowAt(tcpNotSentLowAt);
            return this;
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    @Override
    public IOUringSocketChannelConfig setTrafficClass(int trafficClass) {
        try {
            ((IOUringSocketChannel)this.channel).socket.setTrafficClass(trafficClass);
            return this;
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    public IOUringSocketChannelConfig setTcpKeepIdle(int seconds) {
        try {
            ((IOUringSocketChannel)this.channel).socket.setTcpKeepIdle(seconds);
            return this;
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    public IOUringSocketChannelConfig setTcpKeepIntvl(int seconds) {
        try {
            ((IOUringSocketChannel)this.channel).socket.setTcpKeepIntvl(seconds);
            return this;
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    @Deprecated
    public IOUringSocketChannelConfig setTcpKeepCntl(int probes) {
        return this.setTcpKeepCnt(probes);
    }

    public IOUringSocketChannelConfig setTcpKeepCnt(int probes) {
        try {
            ((IOUringSocketChannel)this.channel).socket.setTcpKeepCnt(probes);
            return this;
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    public IOUringSocketChannelConfig setTcpUserTimeout(int milliseconds) {
        try {
            ((IOUringSocketChannel)this.channel).socket.setTcpUserTimeout(milliseconds);
            return this;
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    public boolean isIpTransparent() {
        try {
            return ((IOUringSocketChannel)this.channel).socket.isIpTransparent();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    public IOUringSocketChannelConfig setIpTransparent(boolean transparent) {
        try {
            ((IOUringSocketChannel)this.channel).socket.setIpTransparent(transparent);
            return this;
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    public IOUringSocketChannelConfig setTcpQuickAck(boolean quickAck) {
        try {
            ((IOUringSocketChannel)this.channel).socket.setTcpQuickAck(quickAck);
            return this;
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    public boolean isTcpQuickAck() {
        try {
            return ((IOUringSocketChannel)this.channel).socket.isTcpQuickAck();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    public IOUringSocketChannelConfig setTcpFastOpenConnect(boolean fastOpenConnect) {
        try {
            ((IOUringSocketChannel)this.channel).socket.setTcpFastOpenConnect(fastOpenConnect);
            return this;
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    public boolean isTcpFastOpenConnect() {
        try {
            return ((IOUringSocketChannel)this.channel).socket.isTcpFastOpenConnect();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    @Override
    public boolean isAllowHalfClosure() {
        return this.allowHalfClosure;
    }

    @Override
    public IOUringSocketChannelConfig setAllowHalfClosure(boolean allowHalfClosure) {
        this.allowHalfClosure = allowHalfClosure;
        return this;
    }

    @Override
    public IOUringSocketChannelConfig setConnectTimeoutMillis(int connectTimeoutMillis) {
        super.setConnectTimeoutMillis(connectTimeoutMillis);
        return this;
    }

    @Override
    @Deprecated
    public IOUringSocketChannelConfig setMaxMessagesPerRead(int maxMessagesPerRead) {
        super.setMaxMessagesPerRead(maxMessagesPerRead);
        return this;
    }

    @Override
    public IOUringSocketChannelConfig setWriteSpinCount(int writeSpinCount) {
        super.setWriteSpinCount(writeSpinCount);
        return this;
    }

    @Override
    public IOUringSocketChannelConfig setAllocator(ByteBufAllocator allocator) {
        super.setAllocator(allocator);
        return this;
    }

    @Override
    public IOUringSocketChannelConfig setRecvByteBufAllocator(RecvByteBufAllocator allocator) {
        super.setRecvByteBufAllocator(allocator);
        return this;
    }

    @Override
    public IOUringSocketChannelConfig setAutoRead(boolean autoRead) {
        super.setAutoRead(autoRead);
        return this;
    }

    @Override
    public IOUringSocketChannelConfig setAutoClose(boolean autoClose) {
        super.setAutoClose(autoClose);
        return this;
    }

    @Override
    @Deprecated
    public IOUringSocketChannelConfig setWriteBufferHighWaterMark(int writeBufferHighWaterMark) {
        super.setWriteBufferHighWaterMark(writeBufferHighWaterMark);
        return this;
    }

    @Override
    @Deprecated
    public IOUringSocketChannelConfig setWriteBufferLowWaterMark(int writeBufferLowWaterMark) {
        super.setWriteBufferLowWaterMark(writeBufferLowWaterMark);
        return this;
    }

    @Override
    public IOUringSocketChannelConfig setWriteBufferWaterMark(WriteBufferWaterMark writeBufferWaterMark) {
        super.setWriteBufferWaterMark(writeBufferWaterMark);
        return this;
    }

    @Override
    public IOUringSocketChannelConfig setMessageSizeEstimator(MessageSizeEstimator estimator) {
        super.setMessageSizeEstimator(estimator);
        return this;
    }
}

