#
#  BEGIN LICENSE
#  Copyright (c) Blue Mind SAS, 2012-2016
# 
#  This file is part of BlueMind. BlueMind is a messaging and collaborative
#  solution.
# 
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of either the GNU Affero General Public License as
#  published by the Free Software Foundation (version 3 of the License).
# 
# 
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# 
#  See LICENSE.txt
#  END LICENSE
#
import requests
import json
from netbluemind.python import serder
from netbluemind.python.client import BaseEndpoint

ISecurityMgmt_VERSION = "4.9.3879"

class ISecurityMgmt(BaseEndpoint):
    def __init__(self, apiKey, url ):
        self.url = url
        self.apiKey = apiKey
        self.base = url +'/system/security'

    def updateFirewallRules (self):
        postUri = "/_updatefirewallrules";
        __data__ = None
        __encoded__ = None
        queryParams = {  };

        response = requests.post( self.base + postUri, params = queryParams, verify=False, headers = {'X-BM-ApiKey' : self.apiKey, 'Accept' : 'application/json', 'X-BM-ClientVersion' : ISecurityMgmt_VERSION}, data = __encoded__);
        from netbluemind.core.task.api.TaskRef import TaskRef
        from netbluemind.core.task.api.TaskRef import __TaskRefSerDer__
        return self.handleResult__(__TaskRefSerDer__(), response)
    def generateLetsEncrypt (self, certData ):
        postUri = "/lets_encrypt";
        __data__ = None
        __encoded__ = None
        from netbluemind.system.api.CertData import CertData
        from netbluemind.system.api.CertData import __CertDataSerDer__
        __data__ = __CertDataSerDer__().encode(certData)
        __encoded__ = json.dumps(__data__)
        queryParams = {   };

        response = requests.post( self.base + postUri, params = queryParams, verify=False, headers = {'X-BM-ApiKey' : self.apiKey, 'Accept' : 'application/json', 'X-BM-ClientVersion' : ISecurityMgmt_VERSION}, data = __encoded__);
        from netbluemind.core.task.api.TaskRef import TaskRef
        from netbluemind.core.task.api.TaskRef import __TaskRefSerDer__
        return self.handleResult__(__TaskRefSerDer__(), response)
    def approveLetsEncryptTos (self, uid ):
        postUri = "/lets_encrypt_tos/{uid}";
        __data__ = None
        __encoded__ = None
        postUri = postUri.replace("{uid}",uid);
        queryParams = {   };

        response = requests.put( self.base + postUri, params = queryParams, verify=False, headers = {'X-BM-ApiKey' : self.apiKey, 'Accept' : 'application/json', 'X-BM-ClientVersion' : ISecurityMgmt_VERSION}, data = __encoded__);
        return self.handleResult__(None, response)
    def updateCertificate (self, certData ):
        postUri = "";
        __data__ = None
        __encoded__ = None
        from netbluemind.system.api.CertData import CertData
        from netbluemind.system.api.CertData import __CertDataSerDer__
        __data__ = __CertDataSerDer__().encode(certData)
        __encoded__ = json.dumps(__data__)
        queryParams = {   };

        response = requests.post( self.base + postUri, params = queryParams, verify=False, headers = {'X-BM-ApiKey' : self.apiKey, 'Accept' : 'application/json', 'X-BM-ClientVersion' : ISecurityMgmt_VERSION}, data = __encoded__);
        return self.handleResult__(None, response)
    def getLetsEncryptTos (self):
        postUri = "/lets_encrypt_tos";
        __data__ = None
        __encoded__ = None
        queryParams = {  };

        response = requests.get( self.base + postUri, params = queryParams, verify=False, headers = {'X-BM-ApiKey' : self.apiKey, 'Accept' : 'application/json', 'X-BM-ClientVersion' : ISecurityMgmt_VERSION}, data = __encoded__);
        return self.handleResult__(serder.STRING, response)
