#
#  BEGIN LICENSE
#  Copyright (c) Blue Mind SAS, 2012-2016
# 
#  This file is part of BlueMind. BlueMind is a messaging and collaborative
#  solution.
# 
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of either the GNU Affero General Public License as
#  published by the Free Software Foundation (version 3 of the License).
# 
# 
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# 
#  See LICENSE.txt
#  END LICENSE
#
import requests
import json
from netbluemind.python import serder
from netbluemind.python.client import BaseEndpoint

ICustomTheme_VERSION = "4.9.3879"

class ICustomTheme(BaseEndpoint):
    def __init__(self, apiKey, url ):
        self.url = url
        self.apiKey = apiKey
        self.base = url +''

    def setLogo (self, logo ):
        postUri = "/logo";
        __data__ = None
        __encoded__ = None
        __data__ = serder.ByteArraySerDer.encode(logo)
        __encoded__ = json.dumps(__data__)
        queryParams = {   };

        response = requests.put( self.base + postUri, params = queryParams, verify=False, headers = {'X-BM-ApiKey' : self.apiKey, 'Accept' : 'application/json', 'X-BM-ClientVersion' : ICustomTheme_VERSION}, data = __encoded__);
        return self.handleResult__(None, response)
    def getLogo (self):
        postUri = "/logo";
        __data__ = None
        __encoded__ = None
        queryParams = {  };

        response = requests.get( self.base + postUri, params = queryParams, verify=False, headers = {'X-BM-ApiKey' : self.apiKey, 'Accept' : 'application/json', 'X-BM-ClientVersion' : ICustomTheme_VERSION}, data = __encoded__);
        from netbluemind.system.api.CustomLogo import CustomLogo
        from netbluemind.system.api.CustomLogo import __CustomLogoSerDer__
        return self.handleResult__(__CustomLogoSerDer__(), response)
    def deleteLogo (self):
        postUri = "/logo";
        __data__ = None
        __encoded__ = None
        queryParams = {  };

        response = requests.delete( self.base + postUri, params = queryParams, verify=False, headers = {'X-BM-ApiKey' : self.apiKey, 'Accept' : 'application/json', 'X-BM-ClientVersion' : ICustomTheme_VERSION}, data = __encoded__);
        return self.handleResult__(None, response)
