<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * Promote.
 */
class Promote  {

  /*
   * @type String
   */
  public $mailboxUid;

  /*
   * @type String
   */
  public $folder;

  /*
   * @type String
   */
  public $hsmId;

  /*
   * @type Integer
   */
  public $imapUid;

  /*
   * @type javautilDate
   */
  public $internalDate;

  /*
   * @type Set
   */
  public $flags;

  /*
   * Constructor
   */
  public function __construct() {
    $this->mailboxUid = "";
    $this->folder = "";
    $this->hsmId = "";
    $this->imapUid = null;
    $this->internalDate = null;
    $this->flags = array();
  }

  public function toMap() {
    $data = array(    
        "mailboxUid" => empty($this->mailboxUid) ? null : $this->mailboxUid,    
        "folder" => empty($this->folder) ? null : $this->folder,    
        "hsmId" => empty($this->hsmId) ? null : $this->hsmId,    
        "imapUid" => empty($this->imapUid) ? null : $this->imapUid,    
        "internalDate" => empty($this->internalDate) ? null : $this->internalDate,    
        "flags" => empty($this->flags) ? null : $this->flags);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
