/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailflow.common.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MessageGwtSerDer implements GwtSerDer<net.bluemind.mailflow.common.api.Message> {

	public MessageGwtSerDer( ) {
	}

	@Override
	public net.bluemind.mailflow.common.api.Message deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.mailflow.common.api.Message ret = new net.bluemind.mailflow.common.api.Message();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.mailflow.common.api.Message ret, JSONObject json) {

		JSONValue sendingAsJSON = json.get("sendingAs");
		ret.sendingAs =  new net.bluemind.mailflow.common.api.gwt.serder.SendingAsGwtSerDer().deserialize(sendingAsJSON);
		JSONValue toJSON = json.get("to");
		ret.to =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize(toJSON);
		JSONValue ccJSON = json.get("cc");
		ret.cc =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize(ccJSON);
		JSONValue recipientsJSON = json.get("recipients");
		ret.recipients =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize(recipientsJSON);
		JSONValue subjectJSON = json.get("subject");
		ret.subject =  GwtSerDerUtils.STRING.deserialize(subjectJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.mailflow.common.api.Message o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.mailflow.common.api.Message o, JSONObject ret) {

		ret.put("sendingAs",  new net.bluemind.mailflow.common.api.gwt.serder.SendingAsGwtSerDer().serialize( o.sendingAs ));
		ret.put("to",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( o.to ));
		ret.put("cc",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( o.cc ));
		ret.put("recipients",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( o.recipients ));
		ret.put("subject",  GwtSerDerUtils.STRING.serialize( o.subject ));
	}
}