<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * Identity.
 */
class Identity  {

  /*
   * @type String
   */
  public $email;

  /*
   * @type SignatureFormat
   */
  public $format;

  /*
   * @type String
   */
  public $signature;

  /*
   * @type String
   */
  public $displayname;

  /*
   * @type String
   */
  public $name;

  /*
   * @type boolean
   */
  public $isDefault;

  /*
   * @type String
   */
  public $sentFolder;

  /*
   * Constructor
   */
  public function __construct() {
    $this->email = "";
    $this->signature = "";
    $this->displayname = "";
    $this->name = "";
    $this->isDefault = false;
    $this->sentFolder = "";
  }

  public function toMap() {
    $data = array(    
        "email" => empty($this->email) ? null : $this->email,    
        "format" => empty($this->format) ? null : $this->format,    
        "signature" => empty($this->signature) ? null : $this->signature,    
        "displayname" => empty($this->displayname) ? null : $this->displayname,    
        "name" => empty($this->name) ? null : $this->name,    
        "isDefault" => empty($this->isDefault) ? null : $this->isDefault,    
        "sentFolder" => empty($this->sentFolder) ? null : $this->sentFolder);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
