/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.notes.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class NoteEndpointPromise implements net.bluemind.notes.api.INotePromise {

	private net.bluemind.notes.api.INoteAsync impl;

	public NoteEndpointPromise(net.bluemind.notes.api.INoteAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<Long> getVersion() {
		
		CompletableFuture<Long> ret = new CompletableFuture<Long>();
		AsyncHandler<Long> handler = new AsyncHandler<Long>() {
			public void success(Long value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getVersion( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>> filteredChangesetById(Long since ,  net.bluemind.core.container.model.ItemFlagFilter arg1  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>> ret = new CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>>();
		AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>> handler = new AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>>() {
			public void success(net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.filteredChangesetById(since, arg1,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemChangelog> itemChangelog(String uid ,  Long arg1  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemChangelog> ret = new CompletableFuture<net.bluemind.core.container.model.ItemChangelog>();
		AsyncHandler<net.bluemind.core.container.model.ItemChangelog> handler = new AsyncHandler<net.bluemind.core.container.model.ItemChangelog>() {
			public void success(net.bluemind.core.container.model.ItemChangelog value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.itemChangelog(uid, arg1,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<String>> changeset(Long since  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<String>> ret = new CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<String>>();
		AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<String>> handler = new AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<String>>() {
			public void success(net.bluemind.core.container.model.ContainerChangeset<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.changeset(since,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<Long>> changesetById(Long since  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<Long>> ret = new CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<Long>>();
		AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<Long>> handler = new AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<Long>>() {
			public void success(net.bluemind.core.container.model.ContainerChangeset<Long> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.changesetById(since,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ContainerChangelog> containerChangelog(Long arg0  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ContainerChangelog> ret = new CompletableFuture<net.bluemind.core.container.model.ContainerChangelog>();
		AsyncHandler<net.bluemind.core.container.model.ContainerChangelog> handler = new AsyncHandler<net.bluemind.core.container.model.ContainerChangelog>() {
			public void success(net.bluemind.core.container.model.ContainerChangelog value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.containerChangelog(arg0,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.api.ListResult<Long>> allIds(String filter ,  Long knownContainerVersion ,  Integer limit ,  Integer offset  ) {
		
		CompletableFuture<net.bluemind.core.api.ListResult<Long>> ret = new CompletableFuture<net.bluemind.core.api.ListResult<Long>>();
		AsyncHandler<net.bluemind.core.api.ListResult<Long>> handler = new AsyncHandler<net.bluemind.core.api.ListResult<Long>>() {
			public void success(net.bluemind.core.api.ListResult<Long> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.allIds(filter, knownContainerVersion, limit, offset,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.api.Count> count(net.bluemind.core.container.model.ItemFlagFilter arg0  ) {
		
		CompletableFuture<net.bluemind.core.container.api.Count> ret = new CompletableFuture<net.bluemind.core.container.api.Count>();
		AsyncHandler<net.bluemind.core.container.api.Count> handler = new AsyncHandler<net.bluemind.core.container.api.Count>() {
			public void success(net.bluemind.core.container.api.Count value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.count(arg0,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>>> multipleGetById(List<Long> arg0  ) {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>>>() {
			public void success(List<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.multipleGetById(arg0,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>> getCompleteById(long id  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getCompleteById(id,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> multipleDeleteById(List<Long> arg0  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.multipleDeleteById(arg0,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.api.Ack> updateById(long id ,  net.bluemind.notes.api.VNote arg1  ) {
		
		CompletableFuture<net.bluemind.core.container.api.Ack> ret = new CompletableFuture<net.bluemind.core.container.api.Ack>();
		AsyncHandler<net.bluemind.core.container.api.Ack> handler = new AsyncHandler<net.bluemind.core.container.api.Ack>() {
			public void success(net.bluemind.core.container.api.Ack value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.updateById(id, arg1,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> deleteById(long id  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.deleteById(id,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.api.Ack> createById(long id ,  net.bluemind.notes.api.VNote arg1  ) {
		
		CompletableFuture<net.bluemind.core.container.api.Ack> ret = new CompletableFuture<net.bluemind.core.container.api.Ack>();
		AsyncHandler<net.bluemind.core.container.api.Ack> handler = new AsyncHandler<net.bluemind.core.container.api.Ack>() {
			public void success(net.bluemind.core.container.api.Ack value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.createById(id, arg1,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<Long>> sortedIds(net.bluemind.core.container.model.SortDescriptor arg0  ) {
		
		CompletableFuture<List<Long>> ret = new CompletableFuture<List<Long>>();
		AsyncHandler<List<Long>> handler = new AsyncHandler<List<Long>>() {
			public void success(List<Long> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.sortedIds(arg0,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<String>> allUids() {
		
		CompletableFuture<List<String>> ret = new CompletableFuture<List<String>>();
		AsyncHandler<List<String>> handler = new AsyncHandler<List<String>>() {
			public void success(List<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.allUids( handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> update(String uid ,  net.bluemind.notes.api.VNote note  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.update(uid, note,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ContainerUpdatesResult> updates(net.bluemind.notes.api.VNoteChanges changes  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ContainerUpdatesResult> ret = new CompletableFuture<net.bluemind.core.container.model.ContainerUpdatesResult>();
		AsyncHandler<net.bluemind.core.container.model.ContainerUpdatesResult> handler = new AsyncHandler<net.bluemind.core.container.model.ContainerUpdatesResult>() {
			public void success(net.bluemind.core.container.model.ContainerUpdatesResult value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.updates(changes,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> delete(String uid  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.delete(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>>> search(net.bluemind.notes.api.VNoteQuery query  ) {
		
		CompletableFuture<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>>> ret = new CompletableFuture<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>>>();
		AsyncHandler<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>>> handler = new AsyncHandler<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>>>() {
			public void success(net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.search(query,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> create(String uid ,  net.bluemind.notes.api.VNote note  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.create(uid, note,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>>> all() {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>>>() {
			public void success(List<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.all( handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>>> multipleGet(List<String> uids  ) {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>>>() {
			public void success(List<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.multipleGet(uids,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>> getComplete(String uid  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.notes.api.VNote> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getComplete(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> reset() {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.reset( handler);
		return ret;
	}

}
