<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * DirEntryQuery.
 */
class DirEntryQuery  {

  /*
   * @type DirEntryQueryOrder
   */
  public $order;

  /*
   * @type String
   */
  public $nameFilter;

  /*
   * @type boolean
   */
  public $hiddenFilter;

  /*
   * @type String
   */
  public $emailFilter;

  /*
   * @type String
   */
  public $nameOrEmailFilter;

  /*
   * @type DirEntryQueryStateFilter
   */
  public $stateFilter;

  /*
   * @type boolean
   */
  public $systemFilter;

  /*
   * @type List
   */
  public $kindsFilter;

  /*
   * @type List
   */
  public $entries;

  /*
   * @type List
   */
  public $orgUnitIds;

  /*
   * @type BaseDirEntryAccountType
   */
  public $accountTypeFilter;

  /*
   * @type int
   */
  public $from;

  /*
   * @type int
   */
  public $size;

  /*
   * @type List
   */
  public $entryUidFilter;

  /*
   * @type boolean
   */
  public $onlyManagable;

  /*
   * @type String
   */
  public $dataLocation;

  /*
   * Constructor
   */
  public function __construct() {
    $this->order =   new DirEntryQueryOrder();
    $this->nameFilter = "";
    $this->hiddenFilter = false;
    $this->emailFilter = "";
    $this->nameOrEmailFilter = "";
    $this->systemFilter = false;
    $this->kindsFilter =  array();
    $this->entries =  array();
    $this->orgUnitIds =  array();
    $this->from = 0;
    $this->size = 0;
    $this->entryUidFilter =  array();
    $this->onlyManagable = false;
    $this->dataLocation = "";
  }

  public function toMap() {
    $data = array(    
        "order" => empty($this->order) ? null : $this->order,    
        "nameFilter" => empty($this->nameFilter) ? null : $this->nameFilter,    
        "hiddenFilter" => empty($this->hiddenFilter) ? null : $this->hiddenFilter,    
        "emailFilter" => empty($this->emailFilter) ? null : $this->emailFilter,    
        "nameOrEmailFilter" => empty($this->nameOrEmailFilter) ? null : $this->nameOrEmailFilter,    
        "stateFilter" => empty($this->stateFilter) ? null : $this->stateFilter,    
        "systemFilter" => empty($this->systemFilter) ? null : $this->systemFilter,    
        "kindsFilter" => empty($this->kindsFilter) ? null : $this->kindsFilter,    
        "entries" => empty($this->entries) ? null : $this->entries,    
        "orgUnitIds" => empty($this->orgUnitIds) ? null : $this->orgUnitIds,    
        "accountTypeFilter" => empty($this->accountTypeFilter) ? null : $this->accountTypeFilter,    
        "from" => empty($this->from) ? null : $this->from,    
        "size" => empty($this->size) ? null : $this->size,    
        "entryUidFilter" => empty($this->entryUidFilter) ? null : $this->entryUidFilter,    
        "onlyManagable" => empty($this->onlyManagable) ? null : $this->onlyManagable,    
        "dataLocation" => empty($this->dataLocation) ? null : $this->dataLocation);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
