/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.attachment.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class AttachedFileGwtSerDer implements GwtSerDer<net.bluemind.attachment.api.AttachedFile> {

	public AttachedFileGwtSerDer( ) {
	}

	@Override
	public net.bluemind.attachment.api.AttachedFile deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.attachment.api.AttachedFile ret = new net.bluemind.attachment.api.AttachedFile();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.attachment.api.AttachedFile ret, JSONObject json) {

		JSONValue publicUrlJSON = json.get("publicUrl");
		ret.publicUrl =  GwtSerDerUtils.STRING.deserialize(publicUrlJSON);
		JSONValue expirationDateJSON = json.get("expirationDate");
		ret.expirationDate =  GwtSerDerUtils.LONG.deserialize(expirationDateJSON);
		JSONValue nameJSON = json.get("name");
		ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
		JSONValue cidJSON = json.get("cid");
		ret.cid =  GwtSerDerUtils.STRING.deserialize(cidJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.attachment.api.AttachedFile o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.attachment.api.AttachedFile o, JSONObject ret) {

		ret.put("publicUrl",  GwtSerDerUtils.STRING.serialize( o.publicUrl ));
		ret.put("expirationDate",  GwtSerDerUtils.LONG.serialize( o.expirationDate ));
		ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
		ret.put("cid",  GwtSerDerUtils.STRING.serialize( o.cid ));
	}
}