/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.cti.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.json.client.JSONValue;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;

public class ComputerTelephonyIntegrationGwtEndpoint implements net.bluemind.cti.api.IComputerTelephonyIntegrationAsync {

	private String baseUri;

	private String sessionId;

	private String root = "/api";

	public ComputerTelephonyIntegrationGwtEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/cti/{domainUid}/{userUid}";
		this.sessionId = sessionId;
	
		uri_ = uri_.replace("{domainUid}",pathVars[0]);
				uri_ = uri_.replace("{userUid}",pathVars[1]);
		
		baseUri = uri_;
	}

	public ComputerTelephonyIntegrationGwtEndpoint withRoot(String root) {
		this.root = root;
		return this;
	}

	@Override
	public void getUserEmails(final AsyncHandler<List<String>> handler) {
		String postUri = "/users";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<String>>(handler) {
			@Override
			protected List<String> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void forward(String component, String phoneNumber, final AsyncHandler<Void> handler) {
		String postUri = "/forward/{component}";

		postUri = postUri.replace("{component}", ""+component);
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&phoneNumber=" + com.google.gwt.http.client.URL.encodeQueryString(""+phoneNumber);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getStatus(final AsyncHandler<net.bluemind.cti.api.Status> handler) {
		String postUri = "/status";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.cti.api.Status>(handler) {
			@Override
			protected net.bluemind.cti.api.Status handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.cti.api.gwt.serder.StatusGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void setStatus(String component, net.bluemind.cti.api.Status status, final AsyncHandler<Void> handler) {
		String postUri = "/status/{component}";

		postUri = postUri.replace("{component}", ""+component);
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.cti.api.gwt.serder.StatusGwtSerDer().serialize( status);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void dial(String number, final AsyncHandler<Void> handler) {
		String postUri = "/dial";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&number=" + com.google.gwt.http.client.URL.encodeQueryString(""+number);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}

	public net.bluemind.cti.api.IComputerTelephonyIntegrationPromise promiseApi() {
		return new ComputerTelephonyIntegrationEndpointPromise(this);
	}
}
