<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2017
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
namespace BM;
require_once 'GlobalEnv.php';

/**
 * Implementation of net.bluemind.group.api.IGroup.
 */

class GroupClient {

  protected $base;
  protected $sid;
  protected $domainUid;

  /*
   * Constructor.
   *
   * @param base
   * @param sid
   * @param domainUid
   *
   */
  public function __construct($base, $sid , $domainUid) {
    $this->sid = $sid;
    $this->base = $base."/api/groups/{domainUid}";
    $this->domainUid = $domainUid;
    $this->base = str_replace("{domainUid}", urlencode($domainUid), $this->base);
  }


  /*
   * @param uid
   * @param arg1
   * @return
   */
  public function setExtId( $uid ,  $arg1  ) {
    $postUri = "/{uid}/_extId";
    $method = "POST";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $arg1;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @return
   */
  public function memberOf( $uid  ) {
    $postUri = "/{uid}/groups";
    $method = "GET";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @return
   */
  public function memberOfGroups( $uid  ) {
    $postUri = "/{uid}/groupUids";
    $method = "GET";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @return
   */
  public function getExpandedUserMembers( $uid  ) {
    $postUri = "/{uid}/expandedusersmembers";
    $method = "GET";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @return
   */
  public function allUids() {
    $postUri = "/_alluids";
    $method = "GET";


    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @param group
   * @return
   */
  public function update( $uid ,  $group  ) {
    $postUri = "/{uid}";
    $method = "POST";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $group;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param name
   * @return
   */
  public function byName( $name  ) {
    $postUri = "/byName/{name}";
    $method = "GET";

    $postUri = str_replace("{name}", urlencode($name), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @return
   */
  public function delete_( $uid  ) {
    $postUri = "/{uid}";
    $method = "DELETE";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @param members
   * @return
   */
  public function remove( $uid ,  $members  ) {
    $postUri = "/{uid}/members";
    $method = "DELETE";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $members;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @return
   */
  public function getParents( $uid  ) {
    $postUri = "/{uid}/parents";
    $method = "GET";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param query
   * @return
   */
  public function search( $query  ) {
    $postUri = "/_search";
    $method = "POST";


    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $query;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @return
   */
  public function getExpandedMembers( $uid  ) {
    $postUri = "/{uid}/expandedmembers";
    $method = "GET";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param email
   * @return
   */
  public function byEmail( $email  ) {
    $postUri = "/byEmail/{email}";
    $method = "GET";

    $postUri = str_replace("{email}", urlencode($email), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @param group
   * @return
   */
  public function create( $uid ,  $group  ) {
    $postUri = "/{uid}";
    $method = "PUT";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $group;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @param roles
   * @return
   */
  public function setRoles( $uid ,  $roles  ) {
    $postUri = "/{uid}/roles";
    $method = "POST";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $roles;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @return
   */
  public function getRoles( $uid  ) {
    $postUri = "/{uid}/roles";
    $method = "GET";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @param members
   * @return
   */
  public function add( $uid ,  $members  ) {
    $postUri = "/{uid}/members";
    $method = "PUT";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $members;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param extid
   * @return
   */
  public function getByExtId( $extid  ) {
    $postUri = "/_extid/{extid}";
    $method = "GET";

    $postUri = str_replace("{extid}", urlencode($extid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @return
   */
  public function touch( $uid  ) {
    $postUri = "/{uid}/_touch";
    $method = "POST";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @return
   */
  public function getComplete( $uid  ) {
    $postUri = "/{uid}/complete";
    $method = "GET";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param roles
   * @return
   */
  public function getGroupsWithRoles( $roles  ) {
    $postUri = "/_rolegroups";
    $method = "POST";


    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $roles;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @param extid
   * @param group
   * @return
   */
  public function createWithExtId( $uid ,  $extid ,  $group  ) {
    $postUri = "/{uid}/{extid}/createwithextid";
    $method = "PUT";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);
    $postUri = str_replace("{extid}", urlencode($extid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $group;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @return
   */
  public function getMembers( $uid  ) {
    $postUri = "/{uid}/members";
    $method = "GET";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }


  /*
   * Execute the request
   *
   * @param url
   * @param data
   * @param body
   */
  private function execute($url, $queryParam, $body, $method) {

    $curl = curl_init();

    $headers = array();
    array_push($headers, 'X-BM-ApiKey: '.$this->sid);

    if (sizeof($queryParam) > 0) {
      $url .= '?'.http_build_query($queryParam);
    }

    curl_setopt_array($curl, GlobalEnv::$curlOptions + array(
      CURLOPT_URL => $url,
      CURLOPT_HTTPHEADER => $headers,
      CURLOPT_CUSTOMREQUEST => $method)
    );

    if ($method == 'POST') {
      curl_setopt($curl, CURLOPT_POST, TRUE);
      curl_setopt($curl, CURLOPT_POSTFIELDS, array());
    }

    if (is_resource($body)) {
      if ($method == 'PUT') {
        curl_setopt($curl, CURLOPT_PUT, TRUE);
      }
      $size = fstat($body)['size'];
      curl_setopt($curl, CURLOPT_INFILE, $body);
      curl_setopt($curl, CURLOPT_INFILESIZE, $size);
    } else {
      if (is_object($body) && method_exists($body, 'serialize')) {
        $body = $body->serialize();
      } else if (is_object($body)) {
        $body = json_encode($body);
      } else if (is_array($body)) {
        $body = json_encode($body);
      } else if (is_string($body)) {
        $body = json_encode($body);
      }
      $size = strlen($body);
      array_push($headers, 'Content-Type: application/json');
      array_push($headers, 'Content-Length: '.$size);
      curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
      curl_setopt($curl, CURLOPT_POSTFIELDS, $body);
    }

    $resp = curl_exec($curl);
    if ($resp === false) {
      throw new \Exception(curl_error($curl));
    } 
    curl_close($curl);
    if (!$resp) {
      return;
    }
    $js = json_decode($resp);
    if ($js === NULL) {
      return $resp;
    }
    if (isset($js->errorCode)) {
      throw new \Exception($js->errorCode . ': ' . (isset($js->message) ? ' : ' . $js->message : ''));
    }
    return $js;
  }

}
