<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * Group.
 */
class Group extends DirBaseValue {

  /*
   * @type String
   */
  public $name;

  /*
   * @type String
   */
  public $description;

  /*
   * @type Map
   */
  public $properties;

  /*
   * @type boolean
   */
  public $hiddenMembers;

  /*
   * @type boolean
   */
  public $mailArchived;

  /*
   * @type Integer
   */
  public $memberCount;

  /*
   * Constructor
   */
  public function __construct() {
  parent::__construct();    $this->name = "";
    $this->description = "";
    $this->properties = array();
    $this->hiddenMembers = false;
    $this->mailArchived = false;
    $this->memberCount = null;
  }

  public function toMap() {
    $data = array(    
        "name" => empty($this->name) ? null : $this->name,    
        "description" => empty($this->description) ? null : $this->description,    
        "properties" => empty($this->properties) ? null : $this->properties,    
        "hiddenMembers" => empty($this->hiddenMembers) ? null : $this->hiddenMembers,    
        "mailArchived" => empty($this->mailArchived) ? null : $this->mailArchived,    
        "memberCount" => empty($this->memberCount) ? null : $this->memberCount);
    return $data;
  }
  
  public function serialize() {
    $parentMap =  $parentMap = parent::toMap();;
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
