/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailbox.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MailboxConfigGwtSerDer implements GwtSerDer<net.bluemind.mailbox.api.MailboxConfig> {

	public MailboxConfigGwtSerDer( ) {
	}

	@Override
	public net.bluemind.mailbox.api.MailboxConfig deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.mailbox.api.MailboxConfig ret = new net.bluemind.mailbox.api.MailboxConfig();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.mailbox.api.MailboxConfig ret, JSONObject json) {

		JSONValue quotaJSON = json.get("quota");
		ret.quota =  GwtSerDerUtils.INT.deserialize(quotaJSON);
		JSONValue messageMaxSizeJSON = json.get("messageMaxSize");
		ret.messageMaxSize =  GwtSerDerUtils.INT.deserialize(messageMaxSizeJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.mailbox.api.MailboxConfig o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.mailbox.api.MailboxConfig o, JSONObject ret) {

		ret.put("quota",  GwtSerDerUtils.INT.serialize( o.quota ));
		ret.put("messageMaxSize",  GwtSerDerUtils.INT.serialize( o.messageMaxSize ));
	}
}