/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.im.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class IMMessageGwtSerDer implements GwtSerDer<net.bluemind.im.api.IMMessage> {

	public IMMessageGwtSerDer( ) {
	}

	@Override
	public net.bluemind.im.api.IMMessage deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.im.api.IMMessage ret = new net.bluemind.im.api.IMMessage();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.im.api.IMMessage ret, JSONObject json) {

		JSONValue timestampJSON = json.get("timestamp");
		ret.timestamp =  GwtSerDerUtils.DATE.deserialize(timestampJSON);
		JSONValue fromJSON = json.get("from");
		ret.from =  GwtSerDerUtils.STRING.deserialize(fromJSON);
		JSONValue toJSON = json.get("to");
		ret.to =  GwtSerDerUtils.STRING.deserialize(toJSON);
		JSONValue bodyJSON = json.get("body");
		ret.body =  GwtSerDerUtils.STRING.deserialize(bodyJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.im.api.IMMessage o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.im.api.IMMessage o, JSONObject ret) {

		ret.put("timestamp",  GwtSerDerUtils.DATE.serialize( o.timestamp ));
		ret.put("from",  GwtSerDerUtils.STRING.serialize( o.from ));
		ret.put("to",  GwtSerDerUtils.STRING.serialize( o.to ));
		ret.put("body",  GwtSerDerUtils.STRING.serialize( o.body ));
	}
}