/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.im.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.json.client.JSONValue;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;

public class InstantMessagingGwtEndpoint implements net.bluemind.im.api.IInstantMessagingAsync {

	private String baseUri;

	private String sessionId;

	private String root = "/api";

	public InstantMessagingGwtEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/im";
		this.sessionId = sessionId;
	

		baseUri = uri_;
	}

	public InstantMessagingGwtEndpoint withRoot(String root) {
		this.root = root;
		return this;
	}

	@Override
	public void getLastMessagesBetween(String user1, String user2, Integer messagesCount, final AsyncHandler<List<net.bluemind.im.api.IMMessage>> handler) {
		String postUri = "/_getLastMessagesBetween";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&user1=" + com.google.gwt.http.client.URL.encodeQueryString(""+user1);
		queryParams += "&user2=" + com.google.gwt.http.client.URL.encodeQueryString(""+user2);
		queryParams += "&messagesCount=" + com.google.gwt.http.client.URL.encodeQueryString(""+messagesCount);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<net.bluemind.im.api.IMMessage>>(handler) {
			@Override
			protected List<net.bluemind.im.api.IMMessage> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.im.api.gwt.serder.IMMessageGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void isActiveUser(String uid, final AsyncHandler<Boolean> handler) {
		String postUri = "/_activeUser/{uid}";

		postUri = postUri.replace("{uid}", ""+uid);
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Boolean>(handler) {
			@Override
			protected Boolean handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.BOOLEAN.deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void sendGroupChatHistory(String sender, String groupChatId, List<String> recipients, final AsyncHandler<Void> handler) {
		String postUri = "/_sendGroupChatHistory/{groupChatId}";

		postUri = postUri.replace("{groupChatId}", ""+groupChatId);
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&sender=" + com.google.gwt.http.client.URL.encodeQueryString(""+sender);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( recipients);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void setRoster(String jabberId, String data, final AsyncHandler<Void> handler) {
		String postUri = "/_setRoster";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&jabberId=" + com.google.gwt.http.client.URL.encodeQueryString(""+jabberId);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = GwtSerDerUtils.STRING.serialize( data);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getRoster(String jabberId, final AsyncHandler<String> handler) {
		String postUri = "/_getRoster";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&jabberId=" + com.google.gwt.http.client.URL.encodeQueryString(""+jabberId);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<String>(handler) {
			@Override
			protected String handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.STRING.deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}

	public net.bluemind.im.api.IInstantMessagingPromise promiseApi() {
		return new InstantMessagingEndpointPromise(this);
	}
}
