/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.im.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class InstantMessagingEndpointPromise implements net.bluemind.im.api.IInstantMessagingPromise {

	private net.bluemind.im.api.IInstantMessagingAsync impl;

	public InstantMessagingEndpointPromise(net.bluemind.im.api.IInstantMessagingAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<List<net.bluemind.im.api.IMMessage>> getLastMessagesBetween(String user1 ,  String user2 ,  Integer messagesCount  ) {
		
		CompletableFuture<List<net.bluemind.im.api.IMMessage>> ret = new CompletableFuture<List<net.bluemind.im.api.IMMessage>>();
		AsyncHandler<List<net.bluemind.im.api.IMMessage>> handler = new AsyncHandler<List<net.bluemind.im.api.IMMessage>>() {
			public void success(List<net.bluemind.im.api.IMMessage> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getLastMessagesBetween(user1, user2, messagesCount,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Boolean> isActiveUser(String uid  ) {
		
		CompletableFuture<Boolean> ret = new CompletableFuture<Boolean>();
		AsyncHandler<Boolean> handler = new AsyncHandler<Boolean>() {
			public void success(Boolean value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.isActiveUser(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> sendGroupChatHistory(String sender ,  String groupChatId ,  List<String> recipients  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.sendGroupChatHistory(sender, groupChatId, recipients,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> setRoster(String jabberId ,  String data  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.setRoster(jabberId, data,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<String> getRoster(String jabberId  ) {
		
		CompletableFuture<String> ret = new CompletableFuture<String>();
		AsyncHandler<String> handler = new AsyncHandler<String>() {
			public void success(String value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getRoster(jabberId,  handler);
		return ret;
	}

}
