<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * VEventSeries.
 */
class VEventSeries  {

  /*
   * @type VEvent
   */
  public $main;

  /*
   * @type List
   */
  public $occurrences;

  /*
   * @type List
   */
  public $counters;

  /*
   * @type Map
   */
  public $properties;

  /*
   * @type String
   */
  public $icsUid;

  /*
   * @type boolean
   */
  public $acceptCounters;

  /*
   * Constructor
   */
  public function __construct() {
    $this->main =   new VEvent();
    $this->occurrences =  array();
    $this->counters =  array();
    $this->properties = array();
    $this->icsUid = "";
    $this->acceptCounters = false;
  }

  public function toMap() {
    $data = array(    
        "main" => empty($this->main) ? null : $this->main,    
        "occurrences" => empty($this->occurrences) ? null : $this->occurrences,    
        "counters" => empty($this->counters) ? null : $this->counters,    
        "properties" => empty($this->properties) ? null : $this->properties,    
        "icsUid" => empty($this->icsUid) ? null : $this->icsUid,    
        "acceptCounters" => empty($this->acceptCounters) ? null : $this->acceptCounters);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
