<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * CalendarLookupResponse.
 */
class CalendarLookupResponse  {

  /*
   * @type String
   */
  public $uid;

  /*
   * @type String
   */
  public $name;

  /*
   * @type CalendarLookupResponseType
   */
  public $type;

  /*
   * @type String
   */
  public $email;

  /*
   * @type int
   */
  public $memberCount;

  /*
   * @type String
   */
  public $ownerUid;

  /*
   * Constructor
   */
  public function __construct() {
    $this->uid = "";
    $this->name = "";
    $this->email = "";
    $this->memberCount = 0;
    $this->ownerUid = "";
  }

  public function toMap() {
    $data = array(    
        "uid" => empty($this->uid) ? null : $this->uid,    
        "name" => empty($this->name) ? null : $this->name,    
        "type" => empty($this->type) ? null : $this->type,    
        "email" => empty($this->email) ? null : $this->email,    
        "memberCount" => empty($this->memberCount) ? null : $this->memberCount,    
        "ownerUid" => empty($this->ownerUid) ? null : $this->ownerUid);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
