/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.scheduledjob.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class JobGwtSerDer implements GwtSerDer<net.bluemind.scheduledjob.api.Job> {

	public JobGwtSerDer( ) {
	}

	@Override
	public net.bluemind.scheduledjob.api.Job deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.scheduledjob.api.Job ret = new net.bluemind.scheduledjob.api.Job();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.scheduledjob.api.Job ret, JSONObject json) {

		JSONValue domainStatusJSON = json.get("domainStatus");
		ret.domainStatus =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.scheduledjob.api.gwt.serder.JobDomainStatusGwtSerDer()).deserialize(domainStatusJSON);
		JSONValue domainPlanificationJSON = json.get("domainPlanification");
		ret.domainPlanification =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.scheduledjob.api.gwt.serder.JobPlanificationGwtSerDer()).deserialize(domainPlanificationJSON);
		JSONValue idJSON = json.get("id");
		ret.id =  GwtSerDerUtils.STRING.deserialize(idJSON);
		JSONValue descriptionJSON = json.get("description");
		ret.description =  GwtSerDerUtils.STRING.deserialize(descriptionJSON);
		JSONValue kindJSON = json.get("kind");
		ret.kind =  new net.bluemind.scheduledjob.api.gwt.serder.JobKindGwtSerDer().deserialize(kindJSON);
		JSONValue sendReportJSON = json.get("sendReport");
		ret.sendReport =  GwtSerDerUtils.BOOLEAN.deserialize(sendReportJSON);
		JSONValue recipientsJSON = json.get("recipients");
		ret.recipients =  GwtSerDerUtils.STRING.deserialize(recipientsJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.scheduledjob.api.Job o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.scheduledjob.api.Job o, JSONObject ret) {

		ret.put("domainStatus",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.scheduledjob.api.gwt.serder.JobDomainStatusGwtSerDer()).serialize( o.domainStatus ));
		ret.put("domainPlanification",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.scheduledjob.api.gwt.serder.JobPlanificationGwtSerDer()).serialize( o.domainPlanification ));
		ret.put("id",  GwtSerDerUtils.STRING.serialize( o.id ));
		ret.put("description",  GwtSerDerUtils.STRING.serialize( o.description ));
		ret.put("kind",  new net.bluemind.scheduledjob.api.gwt.serder.JobKindGwtSerDer().serialize( o.kind ));
		ret.put("sendReport",  GwtSerDerUtils.BOOLEAN.serialize( o.sendReport ));
		ret.put("recipients",  GwtSerDerUtils.STRING.serialize( o.recipients ));
	}
}