/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.scheduledjob.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class JobExecutionQueryGwtSerDer implements GwtSerDer<net.bluemind.scheduledjob.api.JobExecutionQuery> {

	public JobExecutionQueryGwtSerDer( ) {
	}

	@Override
	public net.bluemind.scheduledjob.api.JobExecutionQuery deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.scheduledjob.api.JobExecutionQuery ret = new net.bluemind.scheduledjob.api.JobExecutionQuery();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.scheduledjob.api.JobExecutionQuery ret, JSONObject json) {

		JSONValue jobIdJSON = json.get("jobId");
		ret.jobId =  GwtSerDerUtils.STRING.deserialize(jobIdJSON);
		JSONValue domainJSON = json.get("domain");
		ret.domain =  GwtSerDerUtils.STRING.deserialize(domainJSON);
		JSONValue idJSON = json.get("id");
		ret.id =  GwtSerDerUtils.INT.deserialize(idJSON);
		JSONValue statusesJSON = json.get("statuses");
		ret.statuses =  new GwtSerDerUtils.SetSerDer<>(new net.bluemind.scheduledjob.api.gwt.serder.JobExitStatusGwtSerDer()).deserialize(statusesJSON);
		JSONValue activeJSON = json.get("active");
		ret.active =  GwtSerDerUtils.BOOLEAN.deserialize(activeJSON);
		JSONValue fromJSON = json.get("from");
		ret.from =  GwtSerDerUtils.INT.deserialize(fromJSON);
		JSONValue sizeJSON = json.get("size");
		ret.size =  GwtSerDerUtils.INT.deserialize(sizeJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.scheduledjob.api.JobExecutionQuery o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.scheduledjob.api.JobExecutionQuery o, JSONObject ret) {

		ret.put("jobId",  GwtSerDerUtils.STRING.serialize( o.jobId ));
		ret.put("domain",  GwtSerDerUtils.STRING.serialize( o.domain ));
		ret.put("id",  GwtSerDerUtils.INT.serialize( o.id ));
		ret.put("statuses",  new GwtSerDerUtils.SetSerDer<>(new net.bluemind.scheduledjob.api.gwt.serder.JobExitStatusGwtSerDer()).serialize( o.statuses ));
		ret.put("active",  GwtSerDerUtils.BOOLEAN.serialize( o.active ));
		ret.put("from",  GwtSerDerUtils.INT.serialize( o.from ));
		ret.put("size",  GwtSerDerUtils.INT.serialize( o.size ));
	}
}