/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.scheduledjob.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class JobExecutionGwtSerDer implements GwtSerDer<net.bluemind.scheduledjob.api.JobExecution> {

	public JobExecutionGwtSerDer( ) {
	}

	@Override
	public net.bluemind.scheduledjob.api.JobExecution deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.scheduledjob.api.JobExecution ret = new net.bluemind.scheduledjob.api.JobExecution();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.scheduledjob.api.JobExecution ret, JSONObject json) {

		JSONValue startDateJSON = json.get("startDate");
		ret.startDate =  GwtSerDerUtils.DATE.deserialize(startDateJSON);
		JSONValue endDateJSON = json.get("endDate");
		ret.endDate =  GwtSerDerUtils.DATE.deserialize(endDateJSON);
		JSONValue domainUidJSON = json.get("domainUid");
		ret.domainUid =  GwtSerDerUtils.STRING.deserialize(domainUidJSON);
		JSONValue statusJSON = json.get("status");
		ret.status =  new net.bluemind.scheduledjob.api.gwt.serder.JobExitStatusGwtSerDer().deserialize(statusJSON);
		JSONValue jobIdJSON = json.get("jobId");
		ret.jobId =  GwtSerDerUtils.STRING.deserialize(jobIdJSON);
		JSONValue execGroupJSON = json.get("execGroup");
		ret.execGroup =  GwtSerDerUtils.STRING.deserialize(execGroupJSON);
		JSONValue idJSON = json.get("id");
		ret.id =  GwtSerDerUtils.INT.deserialize(idJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.scheduledjob.api.JobExecution o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.scheduledjob.api.JobExecution o, JSONObject ret) {

		ret.put("startDate",  GwtSerDerUtils.DATE.serialize( o.startDate ));
		ret.put("endDate",  GwtSerDerUtils.DATE.serialize( o.endDate ));
		ret.put("domainUid",  GwtSerDerUtils.STRING.serialize( o.domainUid ));
		ret.put("status",  new net.bluemind.scheduledjob.api.gwt.serder.JobExitStatusGwtSerDer().serialize( o.status ));
		ret.put("jobId",  GwtSerDerUtils.STRING.serialize( o.jobId ));
		ret.put("execGroup",  GwtSerDerUtils.STRING.serialize( o.execGroup ));
		ret.put("id",  GwtSerDerUtils.INT.serialize( o.id ));
	}
}