/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.scheduledjob.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;

public class JobSockJsEndpoint implements net.bluemind.scheduledjob.api.IJobAsync {

	private String rootUri = "/api";

	private String baseUri;

    private String sessionId;

	public JobSockJsEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/scheduledjobs";
		this.sessionId = sessionId;
	

		baseUri = uri_;
	}

	public JobSockJsEndpoint withRoot(String root) {
		this.rootUri = root;
		return this;
	}

	@Override
	public void cancel(String jobId, String domainName, final AsyncHandler<Void> handler) {
		String postUri = "/_cancel/{jobId}";

		postUri = postUri.replace("{jobId}", ""+jobId);
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("domainName", ""+domainName);
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"DELETE",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void deleteExecutions(List<Integer> executions, final AsyncHandler<Void> handler) {
		String postUri = "/_deleteExecutions";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).serialize( executions);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"DELETE",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void getLogs(net.bluemind.scheduledjob.api.JobExecution jobExecution, int offset, final AsyncHandler<Set<net.bluemind.scheduledjob.api.LogEntry>> handler) {
		String postUri = "/_logs";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("offset", ""+offset);
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.scheduledjob.api.gwt.serder.JobExecutionGwtSerDer().serialize( jobExecution);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Set<net.bluemind.scheduledjob.api.LogEntry>>(handler) {
					@Override
			protected Set<net.bluemind.scheduledjob.api.LogEntry> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.SetSerDer<>(new net.bluemind.scheduledjob.api.gwt.serder.LogEntryGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void start(String jobId, String domainName, final AsyncHandler<Void> handler) {
		String postUri = "/_start/{jobId}";

		postUri = postUri.replace("{jobId}", ""+jobId);
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("domainName", ""+domainName);
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void searchJob(net.bluemind.scheduledjob.api.JobQuery query, final AsyncHandler<net.bluemind.core.api.ListResult<net.bluemind.scheduledjob.api.Job>> handler) {
		String postUri = "/_searchJob";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.scheduledjob.api.gwt.serder.JobQueryGwtSerDer().serialize( query);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.api.ListResult<net.bluemind.scheduledjob.api.Job>>(handler) {
					@Override
			protected net.bluemind.core.api.ListResult<net.bluemind.scheduledjob.api.Job> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.api.gwt.serder.ListResultGwtSerDer<>(new net.bluemind.scheduledjob.api.gwt.serder.JobGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void update(net.bluemind.scheduledjob.api.Job job, final AsyncHandler<Void> handler) {
		String postUri = "/_updateJob";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.scheduledjob.api.gwt.serder.JobGwtSerDer().serialize( job);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void searchExecution(net.bluemind.scheduledjob.api.JobExecutionQuery query, final AsyncHandler<net.bluemind.core.api.ListResult<net.bluemind.scheduledjob.api.JobExecution>> handler) {
		String postUri = "/_searchExecution";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.scheduledjob.api.gwt.serder.JobExecutionQueryGwtSerDer().serialize( query);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.api.ListResult<net.bluemind.scheduledjob.api.JobExecution>>(handler) {
					@Override
			protected net.bluemind.core.api.ListResult<net.bluemind.scheduledjob.api.JobExecution> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.api.gwt.serder.ListResultGwtSerDer<>(new net.bluemind.scheduledjob.api.gwt.serder.JobExecutionGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void deleteExecution(int jobExecutionId, final AsyncHandler<Void> handler) {
		String postUri = "/_deleteExecution";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("jobExecutionId", ""+jobExecutionId);
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"DELETE",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void getJobFromId(String jobId, final AsyncHandler<net.bluemind.scheduledjob.api.Job> handler) {
		String postUri = "/_job/{jobId}";

		postUri = postUri.replace("{jobId}", ""+jobId);
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.scheduledjob.api.Job>(handler) {
					@Override
			protected net.bluemind.scheduledjob.api.Job handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.scheduledjob.api.gwt.serder.JobGwtSerDer().deserialize( jsonValue );
			}
		});

	}

	public net.bluemind.scheduledjob.api.IJobPromise promiseApi() {
		return new JobEndpointPromise(this);
	}

}
