<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * DomainTemplateKind.
 */
class DomainTemplateKind  {

  /*
   * @type DomainTemplateDescription
   */
  public $description;

  /*
   * @type List
   */
  public $tags;

  /*
   * @type String
   */
  public $id;

  /*
   * Constructor
   */
  public function __construct() {
    $this->description =   new DomainTemplateDescription();
    $this->tags =  array();
    $this->id = "";
  }

  public function toMap() {
    $data = array(    
        "description" => empty($this->description) ? null : $this->description,    
        "tags" => empty($this->tags) ? null : $this->tags,    
        "id" => empty($this->id) ? null : $this->id);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
