/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.dataprotect.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class RetentionPolicyGwtSerDer implements GwtSerDer<net.bluemind.dataprotect.api.RetentionPolicy> {

	public RetentionPolicyGwtSerDer( ) {
	}

	@Override
	public net.bluemind.dataprotect.api.RetentionPolicy deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.dataprotect.api.RetentionPolicy ret = new net.bluemind.dataprotect.api.RetentionPolicy();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.dataprotect.api.RetentionPolicy ret, JSONObject json) {

		JSONValue dailyJSON = json.get("daily");
		ret.daily =  GwtSerDerUtils.INT.deserialize(dailyJSON);
		JSONValue weeklyJSON = json.get("weekly");
		ret.weekly =  GwtSerDerUtils.INT.deserialize(weeklyJSON);
		JSONValue monthlyJSON = json.get("monthly");
		ret.monthly =  GwtSerDerUtils.INT.deserialize(monthlyJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.dataprotect.api.RetentionPolicy o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.dataprotect.api.RetentionPolicy o, JSONObject ret) {

		ret.put("daily",  GwtSerDerUtils.INT.serialize( o.daily ));
		ret.put("weekly",  GwtSerDerUtils.INT.serialize( o.weekly ));
		ret.put("monthly",  GwtSerDerUtils.INT.serialize( o.monthly ));
	}
}