/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.dataprotect.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class RestoreOperationGwtSerDer implements GwtSerDer<net.bluemind.dataprotect.api.RestoreOperation> {

	public RestoreOperationGwtSerDer( ) {
	}

	@Override
	public net.bluemind.dataprotect.api.RestoreOperation deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.dataprotect.api.RestoreOperation ret = new net.bluemind.dataprotect.api.RestoreOperation();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.dataprotect.api.RestoreOperation ret, JSONObject json) {

		JSONValue identifierJSON = json.get("identifier");
		ret.identifier =  GwtSerDerUtils.STRING.deserialize(identifierJSON);
		JSONValue kindJSON = json.get("kind");
		ret.kind =  new net.bluemind.dataprotect.api.gwt.serder.RestorableKindGwtSerDer().deserialize(kindJSON);
		JSONValue requiredTagJSON = json.get("requiredTag");
		ret.requiredTag =  GwtSerDerUtils.STRING.deserialize(requiredTagJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.dataprotect.api.RestoreOperation o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.dataprotect.api.RestoreOperation o, JSONObject ret) {

		ret.put("identifier",  GwtSerDerUtils.STRING.serialize( o.identifier ));
		ret.put("kind",  new net.bluemind.dataprotect.api.gwt.serder.RestorableKindGwtSerDer().serialize( o.kind ));
		ret.put("requiredTag",  GwtSerDerUtils.STRING.serialize( o.requiredTag ));
	}
}