/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * RPC Client
 */
UserSubscriptionClient._rpcClient;

/**
 * URL
 */
UserSubscriptionClient._baseUrl;

/**
 * @type {string} domainUid
 * @private
 */
UserSubscriptionClient.prototype._domainUid;

/**
 * @constructor
 */ 
function UserSubscriptionClient(base, sid , domainUid ) {
  this._rpcClient = Components.classes["@blue-mind.net/rpcclient;1"].getService().wrappedJSObject;
  this._rpcClient.setAuthKey(sid ? sid : null);
  this._baseUrl = base + '/api/users/{domainUid}/subscriptions';
  
  this._domainUid = domainUid;
  this._baseUrl = this._baseUrl.replace('{domainUid}',domainUid);
};

UserSubscriptionClient.prototype.setAuthKey = function(sid) {
    this._rpcClient.setAuthKey(sid);
};

/*
 *
 */
UserSubscriptionClient.prototype.subscribe = function( subject ,  subscriptions  ) {
  let url = this._baseUrl + "/{subject}/_subscribe";

  url = url.replace("{subject}", subject);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = subscriptions;
  return this._execute(cmd, body);
};

/*
 *
 */
UserSubscriptionClient.prototype.subscribers = function( containerUid  ) {
  let url = this._baseUrl + "/_subscribers/{containerUid}";

  url = url.replace("{containerUid}", containerUid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
UserSubscriptionClient.prototype.unsubscribe = function( subject ,  containers  ) {
  let url = this._baseUrl + "/{subject}/_unsubscribe";

  url = url.replace("{subject}", subject);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = containers;
  return this._execute(cmd, body);
};

/*
 *
 */
UserSubscriptionClient.prototype.listSubscriptions = function( subject ,  type  ) {
  let url = this._baseUrl + "/{subject}";

  url = url.replace("{subject}", subject);

  url += "?type=" + encodeURIComponent(type);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

UserSubscriptionClient.prototype._execute = function(cmd, data) {
  cmd.getData = function() {
    if (data != null){
      return JSON.stringify(data);
    } 
    return null;
  };

  cmd.onSuccess = function(xhr) {
    let contentType = xhr.getResponseHeader("content-type");
    if (contentType == "application/json" && xhr.responseText) {
      cmd.resolve(JSON.parse(xhr.responseText));
    } else {
      cmd.resolve(xhr.response);
    }
  };

  cmd.onFailure = function(xhr) {
    let resp = xhr.response;
    if (resp != null) {
        cmd.reject(resp);
    } else {
        cmd.reject(xhr.status);
    }
  };

  let self = this;
  let result = new Promise(function(resolve, reject) {
    try {
      cmd.resolve = resolve;
      cmd.reject = reject;
      self._rpcClient.execute(cmd);
    } catch(e) {
      reject(e);
    }
  });
  return result;
}
