/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * RPC Client
 */
UserExternalAccountClient._rpcClient;

/**
 * URL
 */
UserExternalAccountClient._baseUrl;

/**
 * @type {string} domain
 * @private
 */
UserExternalAccountClient.prototype._domain;

/**
 * @type {string} uid
 * @private
 */
UserExternalAccountClient.prototype._uid;

/**
 * @constructor
 */ 
function UserExternalAccountClient(base, sid , domain , uid ) {
  this._rpcClient = Components.classes["@blue-mind.net/rpcclient;1"].getService().wrappedJSObject;
  this._rpcClient.setAuthKey(sid ? sid : null);
  this._baseUrl = base + '/api/users/{domain}/{uid}/accounts';
  
  this._domain = domain;
  this._baseUrl = this._baseUrl.replace('{domain}',domain);
  this._uid = uid;
  this._baseUrl = this._baseUrl.replace('{uid}',uid);
};

UserExternalAccountClient.prototype.setAuthKey = function(sid) {
    this._rpcClient.setAuthKey(sid);
};

/*
 *
 */
UserExternalAccountClient.prototype.getAll = function() {
  let url = this._baseUrl;


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
UserExternalAccountClient.prototype.deleteAll = function() {
  let url = this._baseUrl;


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
UserExternalAccountClient.prototype.update = function( system ,  account  ) {
  let url = this._baseUrl + "/{system}";

  url = url.replace("{system}", system);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = account;
  return this._execute(cmd, body);
};

/*
 *
 */
UserExternalAccountClient.prototype.delete_ = function( system  ) {
  let url = this._baseUrl + "/{system}";

  url = url.replace("{system}", system);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
UserExternalAccountClient.prototype.get = function( system  ) {
  let url = this._baseUrl + "/{system}";

  url = url.replace("{system}", system);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
UserExternalAccountClient.prototype.create = function( system ,  account  ) {
  let url = this._baseUrl + "/{system}";

  url = url.replace("{system}", system);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = account;
  return this._execute(cmd, body);
};

UserExternalAccountClient.prototype._execute = function(cmd, data) {
  cmd.getData = function() {
    if (data != null){
      return JSON.stringify(data);
    } 
    return null;
  };

  cmd.onSuccess = function(xhr) {
    let contentType = xhr.getResponseHeader("content-type");
    if (contentType == "application/json" && xhr.responseText) {
      cmd.resolve(JSON.parse(xhr.responseText));
    } else {
      cmd.resolve(xhr.response);
    }
  };

  cmd.onFailure = function(xhr) {
    let resp = xhr.response;
    if (resp != null) {
        cmd.reject(resp);
    } else {
        cmd.reject(xhr.status);
    }
  };

  let self = this;
  let result = new Promise(function(resolve, reject) {
    try {
      cmd.resolve = resolve;
      cmd.reject = reject;
      self._rpcClient.execute(cmd);
    } catch(e) {
      reject(e);
    }
  });
  return result;
}
